-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class Efuse.WriteReq
---@field Data integer[]
local TWriteReq = {}
TWriteReq.__index = TWriteReq
TWriteReq.group = {}

local function TWriteReq_from_obj(obj)
    return setmetatable(obj, TWriteReq)
end

function TWriteReq.new(Data)
    return TWriteReq_from_obj({Data = Data})
end
---@param obj Efuse.WriteReq
function TWriteReq:init_from_obj(obj)
    self.Data = obj.Data
end

function TWriteReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TWriteReq.group)
end

TWriteReq.from_obj = TWriteReq_from_obj

TWriteReq.proto_property = {'Data'}

TWriteReq.default = {{}}

TWriteReq.struct = {{name = 'Data', is_array = true, struct = nil}}

function TWriteReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.RequiredArray(prefix .. 'Data', self.Data, 'uint8', false, errs)

    TWriteReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TWriteReq.proto_property, errs)
    return self
end

function TWriteReq:unpack(_)
    return self.Data
end

msg.WriteReq = TWriteReq

local Efuse = {}

local Mdb = require 'mc.mdb'

---@class Efuse: Table
Efuse.Efuse = Mdb.register_interface('bmc.kepler.Soc.Efuse', {},
    {Write = {'a{ss}ay', '', msg.WriteReq, nil}}, {})
return Efuse
