-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class Session.SessionDeleteRsp
local TSessionDeleteRsp = {}
TSessionDeleteRsp.__index = TSessionDeleteRsp
TSessionDeleteRsp.group = {}

local function TSessionDeleteRsp_from_obj(obj)
    return setmetatable(obj, TSessionDeleteRsp)
end

function TSessionDeleteRsp.new()
    return TSessionDeleteRsp_from_obj({})
end
---@param obj Session.SessionDeleteRsp
function TSessionDeleteRsp:init_from_obj(obj)

end

function TSessionDeleteRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSessionDeleteRsp.group)
end

TSessionDeleteRsp.from_obj = TSessionDeleteRsp_from_obj

TSessionDeleteRsp.proto_property = {}

TSessionDeleteRsp.default = {}

TSessionDeleteRsp.struct = {}

function TSessionDeleteRsp:validate(prefix, errs)
    prefix = prefix or ''

    TSessionDeleteRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSessionDeleteRsp.proto_property, errs)
    return self
end

function TSessionDeleteRsp:unpack(_)
end

msg.SessionDeleteRsp = TSessionDeleteRsp

---@class Session.SessionDeleteReq
---@field LogoutType integer
local TSessionDeleteReq = {}
TSessionDeleteReq.__index = TSessionDeleteReq
TSessionDeleteReq.group = {}

local function TSessionDeleteReq_from_obj(obj)
    return setmetatable(obj, TSessionDeleteReq)
end

function TSessionDeleteReq.new(LogoutType)
    return TSessionDeleteReq_from_obj({LogoutType = LogoutType})
end
---@param obj Session.SessionDeleteReq
function TSessionDeleteReq:init_from_obj(obj)
    self.LogoutType = obj.LogoutType
end

function TSessionDeleteReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSessionDeleteReq.group)
end

TSessionDeleteReq.from_obj = TSessionDeleteReq_from_obj

TSessionDeleteReq.proto_property = {'LogoutType'}

TSessionDeleteReq.default = {0}

TSessionDeleteReq.struct = {{name = 'LogoutType', is_array = false, struct = nil}}

function TSessionDeleteReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'LogoutType', self.LogoutType, 'uint8', false, errs)

    TSessionDeleteReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSessionDeleteReq.proto_property, errs)
    return self
end

function TSessionDeleteReq:unpack(_)
    return self.LogoutType
end

msg.SessionDeleteReq = TSessionDeleteReq

local Session = {}

local Mdb = require 'mc.mdb'

---@class Session: Table
---@field ClientOriginIPAddress string
---@field CreatedTime string
---@field SessionId string
---@field OemSessionType integer
---@field AccountPassword string
---@field SessionType string
---@field UserName string
---@field LastLoginIp string
---@field LastLoginTime string
---@field AuthType integer
---@field Role string[]
---@field Privileges string[]
---@field AccountId string
---@field BrowserType integer
Session.Session = Mdb.register_interface('bmc.kepler.SessionService.Session', {
    ClientOriginIPAddress = {'s', nil, true, nil},
    CreatedTime = {'s', nil, true, nil},
    SessionId = {'s', nil, true, nil},
    OemSessionType = {'y', nil, true, nil},
    AccountPassword = {'s', nil, true, nil},
    SessionType = {'s', nil, true, nil},
    UserName = {'s', nil, true, nil},
    LastLoginIp = {'s', nil, true, nil},
    LastLoginTime = {'s', nil, true, nil},
    AuthType = {'y', nil, true, nil},
    Role = {'as', nil, true, nil},
    Privileges = {'as', nil, true, nil},
    AccountId = {'s', nil, true, nil},
    BrowserType = {'y', nil, true, nil}
}, {SessionDelete = {'a{ss}y', '', msg.SessionDeleteReq, msg.SessionDeleteRsp}}, {})
return Session
