-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class Uart.SetParityBitReq
---@field UartId integer
---@field ParityBit integer
local TSetParityBitReq = {}
TSetParityBitReq.__index = TSetParityBitReq
TSetParityBitReq.group = {}

local function TSetParityBitReq_from_obj(obj)
    return setmetatable(obj, TSetParityBitReq)
end

function TSetParityBitReq.new(UartId, ParityBit)
    return TSetParityBitReq_from_obj({UartId = UartId, ParityBit = ParityBit})
end
---@param obj Uart.SetParityBitReq
function TSetParityBitReq:init_from_obj(obj)
    self.UartId = obj.UartId
    self.ParityBit = obj.ParityBit
end

function TSetParityBitReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetParityBitReq.group)
end

TSetParityBitReq.from_obj = TSetParityBitReq_from_obj

TSetParityBitReq.proto_property = {'UartId', 'ParityBit'}

TSetParityBitReq.default = {0, 0}

TSetParityBitReq.struct = {
    {name = 'UartId', is_array = false, struct = nil},
    {name = 'ParityBit', is_array = false, struct = nil}
}

function TSetParityBitReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'UartId', self.UartId, 'uint8', false, errs)
    validate.Required(prefix .. 'ParityBit', self.ParityBit, 'uint8', false, errs)

    TSetParityBitReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetParityBitReq.proto_property, errs)
    return self
end

function TSetParityBitReq:unpack(_)
    return self.UartId, self.ParityBit
end

msg.SetParityBitReq = TSetParityBitReq

---@class Uart.SetStopBitReq
---@field UartId integer
---@field StopBit integer
local TSetStopBitReq = {}
TSetStopBitReq.__index = TSetStopBitReq
TSetStopBitReq.group = {}

local function TSetStopBitReq_from_obj(obj)
    return setmetatable(obj, TSetStopBitReq)
end

function TSetStopBitReq.new(UartId, StopBit)
    return TSetStopBitReq_from_obj({UartId = UartId, StopBit = StopBit})
end
---@param obj Uart.SetStopBitReq
function TSetStopBitReq:init_from_obj(obj)
    self.UartId = obj.UartId
    self.StopBit = obj.StopBit
end

function TSetStopBitReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetStopBitReq.group)
end

TSetStopBitReq.from_obj = TSetStopBitReq_from_obj

TSetStopBitReq.proto_property = {'UartId', 'StopBit'}

TSetStopBitReq.default = {0, 0}

TSetStopBitReq.struct = {
    {name = 'UartId', is_array = false, struct = nil},
    {name = 'StopBit', is_array = false, struct = nil}
}

function TSetStopBitReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'UartId', self.UartId, 'uint8', false, errs)
    validate.Required(prefix .. 'StopBit', self.StopBit, 'uint8', false, errs)

    TSetStopBitReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetStopBitReq.proto_property, errs)
    return self
end

function TSetStopBitReq:unpack(_)
    return self.UartId, self.StopBit
end

msg.SetStopBitReq = TSetStopBitReq

---@class Uart.SetDataBitReq
---@field UartId integer
---@field DataBit integer
local TSetDataBitReq = {}
TSetDataBitReq.__index = TSetDataBitReq
TSetDataBitReq.group = {}

local function TSetDataBitReq_from_obj(obj)
    return setmetatable(obj, TSetDataBitReq)
end

function TSetDataBitReq.new(UartId, DataBit)
    return TSetDataBitReq_from_obj({UartId = UartId, DataBit = DataBit})
end
---@param obj Uart.SetDataBitReq
function TSetDataBitReq:init_from_obj(obj)
    self.UartId = obj.UartId
    self.DataBit = obj.DataBit
end

function TSetDataBitReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDataBitReq.group)
end

TSetDataBitReq.from_obj = TSetDataBitReq_from_obj

TSetDataBitReq.proto_property = {'UartId', 'DataBit'}

TSetDataBitReq.default = {0, 0}

TSetDataBitReq.struct = {
    {name = 'UartId', is_array = false, struct = nil},
    {name = 'DataBit', is_array = false, struct = nil}
}

function TSetDataBitReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'UartId', self.UartId, 'uint8', false, errs)
    validate.Required(prefix .. 'DataBit', self.DataBit, 'uint8', false, errs)

    TSetDataBitReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDataBitReq.proto_property, errs)
    return self
end

function TSetDataBitReq:unpack(_)
    return self.UartId, self.DataBit
end

msg.SetDataBitReq = TSetDataBitReq

---@class Uart.SetBaudRateReq
---@field UartId integer
---@field BaudRate integer
local TSetBaudRateReq = {}
TSetBaudRateReq.__index = TSetBaudRateReq
TSetBaudRateReq.group = {}

local function TSetBaudRateReq_from_obj(obj)
    return setmetatable(obj, TSetBaudRateReq)
end

function TSetBaudRateReq.new(UartId, BaudRate)
    return TSetBaudRateReq_from_obj({UartId = UartId, BaudRate = BaudRate})
end
---@param obj Uart.SetBaudRateReq
function TSetBaudRateReq:init_from_obj(obj)
    self.UartId = obj.UartId
    self.BaudRate = obj.BaudRate
end

function TSetBaudRateReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBaudRateReq.group)
end

TSetBaudRateReq.from_obj = TSetBaudRateReq_from_obj

TSetBaudRateReq.proto_property = {'UartId', 'BaudRate'}

TSetBaudRateReq.default = {0, 0}

TSetBaudRateReq.struct = {
    {name = 'UartId', is_array = false, struct = nil},
    {name = 'BaudRate', is_array = false, struct = nil}
}

function TSetBaudRateReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'UartId', self.UartId, 'uint8', false, errs)
    validate.Required(prefix .. 'BaudRate', self.BaudRate, 'uint32', false, errs)

    TSetBaudRateReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBaudRateReq.proto_property, errs)
    return self
end

function TSetBaudRateReq:unpack(_)
    return self.UartId, self.BaudRate
end

msg.SetBaudRateReq = TSetBaudRateReq

---@class Uart.UartCloseReq
---@field UartId integer
local TUartCloseReq = {}
TUartCloseReq.__index = TUartCloseReq
TUartCloseReq.group = {}

local function TUartCloseReq_from_obj(obj)
    return setmetatable(obj, TUartCloseReq)
end

function TUartCloseReq.new(UartId)
    return TUartCloseReq_from_obj({UartId = UartId})
end
---@param obj Uart.UartCloseReq
function TUartCloseReq:init_from_obj(obj)
    self.UartId = obj.UartId
end

function TUartCloseReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUartCloseReq.group)
end

TUartCloseReq.from_obj = TUartCloseReq_from_obj

TUartCloseReq.proto_property = {'UartId'}

TUartCloseReq.default = {0}

TUartCloseReq.struct = {{name = 'UartId', is_array = false, struct = nil}}

function TUartCloseReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'UartId', self.UartId, 'uint8', false, errs)

    TUartCloseReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUartCloseReq.proto_property, errs)
    return self
end

function TUartCloseReq:unpack(_)
    return self.UartId
end

msg.UartCloseReq = TUartCloseReq

---@class Uart.UartOpenReq
---@field UartId integer
---@field BaudRate integer
local TUartOpenReq = {}
TUartOpenReq.__index = TUartOpenReq
TUartOpenReq.group = {}

local function TUartOpenReq_from_obj(obj)
    return setmetatable(obj, TUartOpenReq)
end

function TUartOpenReq.new(UartId, BaudRate)
    return TUartOpenReq_from_obj({UartId = UartId, BaudRate = BaudRate})
end
---@param obj Uart.UartOpenReq
function TUartOpenReq:init_from_obj(obj)
    self.UartId = obj.UartId
    self.BaudRate = obj.BaudRate
end

function TUartOpenReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUartOpenReq.group)
end

TUartOpenReq.from_obj = TUartOpenReq_from_obj

TUartOpenReq.proto_property = {'UartId', 'BaudRate'}

TUartOpenReq.default = {0, 0}

TUartOpenReq.struct = {
    {name = 'UartId', is_array = false, struct = nil},
    {name = 'BaudRate', is_array = false, struct = nil}
}

function TUartOpenReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'UartId', self.UartId, 'uint8', false, errs)
    validate.Required(prefix .. 'BaudRate', self.BaudRate, 'uint32', false, errs)

    TUartOpenReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUartOpenReq.proto_property, errs)
    return self
end

function TUartOpenReq:unpack(_)
    return self.UartId, self.BaudRate
end

msg.UartOpenReq = TUartOpenReq

---@class Uart.QueryConnectionRsp
---@field UartConnection integer
---@field PortConnection integer
---@field UartPortEnable integer
local TQueryConnectionRsp = {}
TQueryConnectionRsp.__index = TQueryConnectionRsp
TQueryConnectionRsp.group = {}

local function TQueryConnectionRsp_from_obj(obj)
    return setmetatable(obj, TQueryConnectionRsp)
end

function TQueryConnectionRsp.new(UartConnection, PortConnection, UartPortEnable)
    return TQueryConnectionRsp_from_obj({
        UartConnection = UartConnection,
        PortConnection = PortConnection,
        UartPortEnable = UartPortEnable
    })
end
---@param obj Uart.QueryConnectionRsp
function TQueryConnectionRsp:init_from_obj(obj)
    self.UartConnection = obj.UartConnection
    self.PortConnection = obj.PortConnection
    self.UartPortEnable = obj.UartPortEnable
end

function TQueryConnectionRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TQueryConnectionRsp.group)
end

TQueryConnectionRsp.from_obj = TQueryConnectionRsp_from_obj

TQueryConnectionRsp.proto_property = {'UartConnection', 'PortConnection', 'UartPortEnable'}

TQueryConnectionRsp.default = {0, 0, 0}

TQueryConnectionRsp.struct = {
    {name = 'UartConnection', is_array = false, struct = nil},
    {name = 'PortConnection', is_array = false, struct = nil},
    {name = 'UartPortEnable', is_array = false, struct = nil}
}

function TQueryConnectionRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'UartConnection', self.UartConnection, 'uint32', false, errs)
    validate.Required(prefix .. 'PortConnection', self.PortConnection, 'uint32', false, errs)
    validate.Required(prefix .. 'UartPortEnable', self.UartPortEnable, 'uint32', false, errs)

    TQueryConnectionRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TQueryConnectionRsp.proto_property, errs)
    return self
end

function TQueryConnectionRsp:unpack(_)
    return self.UartConnection, self.PortConnection, self.UartPortEnable
end

msg.QueryConnectionRsp = TQueryConnectionRsp

---@class Uart.PortConnectPortReq
---@field SrcPort integer
---@field DestPort integer
local TPortConnectPortReq = {}
TPortConnectPortReq.__index = TPortConnectPortReq
TPortConnectPortReq.group = {}

local function TPortConnectPortReq_from_obj(obj)
    return setmetatable(obj, TPortConnectPortReq)
end

function TPortConnectPortReq.new(SrcPort, DestPort)
    return TPortConnectPortReq_from_obj({SrcPort = SrcPort, DestPort = DestPort})
end
---@param obj Uart.PortConnectPortReq
function TPortConnectPortReq:init_from_obj(obj)
    self.SrcPort = obj.SrcPort
    self.DestPort = obj.DestPort
end

function TPortConnectPortReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPortConnectPortReq.group)
end

TPortConnectPortReq.from_obj = TPortConnectPortReq_from_obj

TPortConnectPortReq.proto_property = {'SrcPort', 'DestPort'}

TPortConnectPortReq.default = {0, 0}

TPortConnectPortReq.struct = {
    {name = 'SrcPort', is_array = false, struct = nil},
    {name = 'DestPort', is_array = false, struct = nil}
}

function TPortConnectPortReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'SrcPort', self.SrcPort, 'uint32', false, errs)
    validate.Required(prefix .. 'DestPort', self.DestPort, 'uint32', false, errs)

    TPortConnectPortReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPortConnectPortReq.proto_property, errs)
    return self
end

function TPortConnectPortReq:unpack(_)
    return self.SrcPort, self.DestPort
end

msg.PortConnectPortReq = TPortConnectPortReq

---@class Uart.UartConnectPortReq
---@field SrcUart integer
---@field DestPort integer
local TUartConnectPortReq = {}
TUartConnectPortReq.__index = TUartConnectPortReq
TUartConnectPortReq.group = {}

local function TUartConnectPortReq_from_obj(obj)
    return setmetatable(obj, TUartConnectPortReq)
end

function TUartConnectPortReq.new(SrcUart, DestPort)
    return TUartConnectPortReq_from_obj({SrcUart = SrcUart, DestPort = DestPort})
end
---@param obj Uart.UartConnectPortReq
function TUartConnectPortReq:init_from_obj(obj)
    self.SrcUart = obj.SrcUart
    self.DestPort = obj.DestPort
end

function TUartConnectPortReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUartConnectPortReq.group)
end

TUartConnectPortReq.from_obj = TUartConnectPortReq_from_obj

TUartConnectPortReq.proto_property = {'SrcUart', 'DestPort'}

TUartConnectPortReq.default = {0, 0}

TUartConnectPortReq.struct = {
    {name = 'SrcUart', is_array = false, struct = nil},
    {name = 'DestPort', is_array = false, struct = nil}
}

function TUartConnectPortReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'SrcUart', self.SrcUart, 'uint32', false, errs)
    validate.Required(prefix .. 'DestPort', self.DestPort, 'uint32', false, errs)

    TUartConnectPortReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUartConnectPortReq.proto_property, errs)
    return self
end

function TUartConnectPortReq:unpack(_)
    return self.SrcUart, self.DestPort
end

msg.UartConnectPortReq = TUartConnectPortReq

---@class Uart.UartConnectUartReq
---@field SrcUart integer
---@field DestUart integer
local TUartConnectUartReq = {}
TUartConnectUartReq.__index = TUartConnectUartReq
TUartConnectUartReq.group = {}

local function TUartConnectUartReq_from_obj(obj)
    return setmetatable(obj, TUartConnectUartReq)
end

function TUartConnectUartReq.new(SrcUart, DestUart)
    return TUartConnectUartReq_from_obj({SrcUart = SrcUart, DestUart = DestUart})
end
---@param obj Uart.UartConnectUartReq
function TUartConnectUartReq:init_from_obj(obj)
    self.SrcUart = obj.SrcUart
    self.DestUart = obj.DestUart
end

function TUartConnectUartReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUartConnectUartReq.group)
end

TUartConnectUartReq.from_obj = TUartConnectUartReq_from_obj

TUartConnectUartReq.proto_property = {'SrcUart', 'DestUart'}

TUartConnectUartReq.default = {0, 0}

TUartConnectUartReq.struct = {
    {name = 'SrcUart', is_array = false, struct = nil},
    {name = 'DestUart', is_array = false, struct = nil}
}

function TUartConnectUartReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'SrcUart', self.SrcUart, 'uint32', false, errs)
    validate.Required(prefix .. 'DestUart', self.DestUart, 'uint32', false, errs)

    TUartConnectUartReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUartConnectUartReq.proto_property, errs)
    return self
end

function TUartConnectUartReq:unpack(_)
    return self.SrcUart, self.DestUart
end

msg.UartConnectUartReq = TUartConnectUartReq

local Uart = {}

local Mdb = require 'mc.mdb'

---@class Uart: Table
Uart.Uart = Mdb.register_interface('bmc.kepler.Managers.Uart', {}, {
    UartConnectUart = {'a{ss}uu', '', msg.UartConnectUartReq, nil},
    UartConnectPort = {'a{ss}uu', '', msg.UartConnectPortReq, nil},
    PortConnectPort = {'a{ss}uu', '', msg.PortConnectPortReq, nil},
    QueryConnection = {'a{ss}', 'uuu', nil, msg.QueryConnectionRsp},
    UartOpen = {'a{ss}yu', '', msg.UartOpenReq, nil},
    UartClose = {'a{ss}y', '', msg.UartCloseReq, nil},
    SetBaudRate = {'a{ss}yu', '', msg.SetBaudRateReq, nil},
    SetDataBit = {'a{ss}yy', '', msg.SetDataBitReq, nil},
    SetStopBit = {'a{ss}yy', '', msg.SetStopBitReq, nil},
    SetParityBit = {'a{ss}yy', '', msg.SetParityBitReq, nil}
}, {})
return Uart
