-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'
local create_enum_type = require 'mc.enum'

local msg = {}
local defs = {}

---@class defs.SslVersion: Enum
local ESslVersion = create_enum_type('SslVersion')
ESslVersion.default = ESslVersion.new(2147483647)
ESslVersion.struct = nil
ESslVersion.TLS_1_2 = ESslVersion.new(0)
ESslVersion.TLS_1_3 = ESslVersion.new(1)

defs.SslVersion = ESslVersion

---@class defs.description
local Tdescription = {}
Tdescription.__index = Tdescription
Tdescription.group = {}

local function Tdescription_from_obj(obj)
    return setmetatable(obj, Tdescription)
end

function Tdescription.new()
    return Tdescription_from_obj({})
end
---@param obj defs.description
function Tdescription:init_from_obj(obj)

end

function Tdescription:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, Tdescription.group)
end

Tdescription.from_obj = Tdescription_from_obj

Tdescription.proto_property = {}

Tdescription.default = {}

Tdescription.struct = {}

function Tdescription:validate(prefix, errs)
    prefix = prefix or ''

    Tdescription:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, Tdescription.proto_property, errs)
    return self
end

function Tdescription:unpack(_)
end

defs.description = Tdescription

local TlsVersion = {}

local Mdb = require 'mc.mdb'

---@class TlsVersion: Table
---@field Version defs.SslVersion
TlsVersion.TlsVersion = Mdb.register_interface('bmc.kepler.Managers.Security.TlsConfig.TlsVersion',
    {Version = {'i', nil, false, nil}}, {}, {})
return TlsVersion
