-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'
local create_enum_type = require 'mc.enum'

local msg = {}
local defs = {}

---@class defs.SslCipherSuit: Enum
local ESslCipherSuit = create_enum_type('SslCipherSuit')
ESslCipherSuit.default = ESslCipherSuit.new(2147483647)
ESslCipherSuit.struct = nil
ESslCipherSuit.ECDHE_RSA_AES256_GCM_SHA384 = ESslCipherSuit.new(0)
ESslCipherSuit.ECDHE_ECDSA_AES256_GCM_SHA384 = ESslCipherSuit.new(1)
ESslCipherSuit.DHE_DSS_AES256_GCM_SHA384 = ESslCipherSuit.new(2)
ESslCipherSuit.DHE_RSA_AES256_GCM_SHA384 = ESslCipherSuit.new(3)
ESslCipherSuit.ECDHE_RSA_AES128_GCM_SHA256 = ESslCipherSuit.new(4)
ESslCipherSuit.ECDHE_ECDSA_AES128_GCM_SHA256 = ESslCipherSuit.new(5)
ESslCipherSuit.DHE_DSS_AES128_GCM_SHA256 = ESslCipherSuit.new(6)
ESslCipherSuit.DHE_RSA_AES128_GCM_SHA256 = ESslCipherSuit.new(7)
ESslCipherSuit.DHE_PSK_AES128_GCM_SHA256 = ESslCipherSuit.new(8)
ESslCipherSuit.DHE_PSK_AES256_GCM_SHA384 = ESslCipherSuit.new(9)
ESslCipherSuit.DHE_PSK_CHACHA20_POLY1305 = ESslCipherSuit.new(10)
ESslCipherSuit.ECDHE_RSA_CHACHA20_POLY1305 = ESslCipherSuit.new(11)
ESslCipherSuit.ECDHE_PSK_CHACHA20_POLY1305 = ESslCipherSuit.new(12)
ESslCipherSuit.DHE_RSA_AES128_CCM = ESslCipherSuit.new(13)
ESslCipherSuit.DHE_RSA_AES256_CCM = ESslCipherSuit.new(14)
ESslCipherSuit.DHE_RSA_CHACHA20_POLY1305 = ESslCipherSuit.new(15)
ESslCipherSuit.DHE_PSK_AES128_CCM = ESslCipherSuit.new(16)
ESslCipherSuit.DHE_PSK_AES256_CCM = ESslCipherSuit.new(17)
ESslCipherSuit.ECDHE_ECDSA_AES128_CCM = ESslCipherSuit.new(18)
ESslCipherSuit.ECDHE_ECDSA_AES256_CCM = ESslCipherSuit.new(19)
ESslCipherSuit.ECDHE_ECDSA_CHACHA20_POLY1305 = ESslCipherSuit.new(20)
ESslCipherSuit.TLS_CHACHA20_POLY1305_SHA256 = ESslCipherSuit.new(21)
ESslCipherSuit.TLS_AES_256_GCM_SHA384 = ESslCipherSuit.new(22)
ESslCipherSuit.TLS_AES_128_GCM_SHA256 = ESslCipherSuit.new(23)

defs.SslCipherSuit = ESslCipherSuit

---@class defs.description
local Tdescription = {}
Tdescription.__index = Tdescription
Tdescription.group = {}

local function Tdescription_from_obj(obj)
    return setmetatable(obj, Tdescription)
end

function Tdescription.new()
    return Tdescription_from_obj({})
end
---@param obj defs.description
function Tdescription:init_from_obj(obj)

end

function Tdescription:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, Tdescription.group)
end

Tdescription.from_obj = Tdescription_from_obj

Tdescription.proto_property = {}

Tdescription.default = {}

Tdescription.struct = {}

function Tdescription:validate(prefix, errs)
    prefix = prefix or ''

    Tdescription:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, Tdescription.proto_property, errs)
    return self
end

function Tdescription:unpack(_)
end

defs.description = Tdescription

---@class CipherSuits.SetSslCipherSuitRsp
local TSetSslCipherSuitRsp = {}
TSetSslCipherSuitRsp.__index = TSetSslCipherSuitRsp
TSetSslCipherSuitRsp.group = {}

local function TSetSslCipherSuitRsp_from_obj(obj)
    return setmetatable(obj, TSetSslCipherSuitRsp)
end

function TSetSslCipherSuitRsp.new()
    return TSetSslCipherSuitRsp_from_obj({})
end
---@param obj CipherSuits.SetSslCipherSuitRsp
function TSetSslCipherSuitRsp:init_from_obj(obj)

end

function TSetSslCipherSuitRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSslCipherSuitRsp.group)
end

TSetSslCipherSuitRsp.from_obj = TSetSslCipherSuitRsp_from_obj

TSetSslCipherSuitRsp.proto_property = {}

TSetSslCipherSuitRsp.default = {}

TSetSslCipherSuitRsp.struct = {}

function TSetSslCipherSuitRsp:validate(prefix, errs)
    prefix = prefix or ''

    TSetSslCipherSuitRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSslCipherSuitRsp.proto_property, errs)
    return self
end

function TSetSslCipherSuitRsp:unpack(_)
end

msg.SetSslCipherSuitRsp = TSetSslCipherSuitRsp

---@class CipherSuits.SetSslCipherSuitReq
---@field SuitArray defs.SslCipherSuit[]
---@field EnableArray boolean[]
local TSetSslCipherSuitReq = {}
TSetSslCipherSuitReq.__index = TSetSslCipherSuitReq
TSetSslCipherSuitReq.group = {}

local function TSetSslCipherSuitReq_from_obj(obj)
    obj.SuitArray = utils.from_obj(defs.SslCipherSuit, obj.SuitArray, true)
    return setmetatable(obj, TSetSslCipherSuitReq)
end

function TSetSslCipherSuitReq.new(SuitArray, EnableArray)
    return TSetSslCipherSuitReq_from_obj({SuitArray = SuitArray, EnableArray = EnableArray})
end
---@param obj CipherSuits.SetSslCipherSuitReq
function TSetSslCipherSuitReq:init_from_obj(obj)
    self.SuitArray = obj.SuitArray
    self.EnableArray = obj.EnableArray
end

function TSetSslCipherSuitReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSslCipherSuitReq.group)
end

TSetSslCipherSuitReq.from_obj = TSetSslCipherSuitReq_from_obj

TSetSslCipherSuitReq.proto_property = {'SuitArray', 'EnableArray'}

TSetSslCipherSuitReq.default = {{}, {}}

TSetSslCipherSuitReq.struct = {
    {name = 'SuitArray', is_array = true, struct = defs.SslCipherSuit.struct},
    {name = 'EnableArray', is_array = true, struct = nil}
}

function TSetSslCipherSuitReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.RequiredArray(prefix .. 'SuitArray', self.SuitArray, 'defs.SslCipherSuit', false, errs)
    validate.RequiredArray(prefix .. 'EnableArray', self.EnableArray, 'bool', false, errs)

    TSetSslCipherSuitReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSslCipherSuitReq.proto_property, errs)
    return self
end

function TSetSslCipherSuitReq:unpack(raw)
    local SuitArray = utils.unpack_enum(raw,
        utils.from_obj(defs.SslCipherSuit, self.SuitArray, true), true)
    return SuitArray, self.EnableArray
end

msg.SetSslCipherSuitReq = TSetSslCipherSuitReq

local CipherSuits = {}

local Mdb = require 'mc.mdb'

---@class CipherSuits: Table
CipherSuits.CipherSuits = Mdb.register_interface(
    'bmc.kepler.Managers.Security.TlsConfig.CipherSuits', {},
    {SetSslCipherSuit = {'a{ss}aiab', '', msg.SetSslCipherSuitReq, msg.SetSslCipherSuitRsp}}, {})
return CipherSuits
