-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class SOL.SetTimeoutRsp
---@field Result integer
local TSetTimeoutRsp = {}
TSetTimeoutRsp.__index = TSetTimeoutRsp
TSetTimeoutRsp.group = {}

local function TSetTimeoutRsp_from_obj(obj)
    return setmetatable(obj, TSetTimeoutRsp)
end

function TSetTimeoutRsp.new(Result)
    return TSetTimeoutRsp_from_obj({Result = Result})
end
---@param obj SOL.SetTimeoutRsp
function TSetTimeoutRsp:init_from_obj(obj)
    self.Result = obj.Result
end

function TSetTimeoutRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetTimeoutRsp.group)
end

TSetTimeoutRsp.from_obj = TSetTimeoutRsp_from_obj

TSetTimeoutRsp.proto_property = {'Result'}

TSetTimeoutRsp.default = {0}

TSetTimeoutRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TSetTimeoutRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Result', self.Result, 'int8', false, errs)

    TSetTimeoutRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetTimeoutRsp.proto_property, errs)
    return self
end

function TSetTimeoutRsp:unpack(_)
    return self.Result
end

msg.SetTimeoutRsp = TSetTimeoutRsp

---@class SOL.SetTimeoutReq
---@field Minutes integer
local TSetTimeoutReq = {}
TSetTimeoutReq.__index = TSetTimeoutReq
TSetTimeoutReq.group = {}

local function TSetTimeoutReq_from_obj(obj)
    return setmetatable(obj, TSetTimeoutReq)
end

function TSetTimeoutReq.new(Minutes)
    return TSetTimeoutReq_from_obj({Minutes = Minutes})
end
---@param obj SOL.SetTimeoutReq
function TSetTimeoutReq:init_from_obj(obj)
    self.Minutes = obj.Minutes
end

function TSetTimeoutReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetTimeoutReq.group)
end

TSetTimeoutReq.from_obj = TSetTimeoutReq_from_obj

TSetTimeoutReq.proto_property = {'Minutes'}

TSetTimeoutReq.default = {0}

TSetTimeoutReq.struct = {{name = 'Minutes', is_array = false, struct = nil}}

function TSetTimeoutReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Minutes', self.Minutes, 'uint16', false, errs)

    TSetTimeoutReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetTimeoutReq.proto_property, errs)
    return self
end

function TSetTimeoutReq:unpack(_)
    return self.Minutes
end

msg.SetTimeoutReq = TSetTimeoutReq

---@class SOL.InitSessionRsp
---@field Result integer
local TInitSessionRsp = {}
TInitSessionRsp.__index = TInitSessionRsp
TInitSessionRsp.group = {}

local function TInitSessionRsp_from_obj(obj)
    return setmetatable(obj, TInitSessionRsp)
end

function TInitSessionRsp.new(Result)
    return TInitSessionRsp_from_obj({Result = Result})
end
---@param obj SOL.InitSessionRsp
function TInitSessionRsp:init_from_obj(obj)
    self.Result = obj.Result
end

function TInitSessionRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInitSessionRsp.group)
end

TInitSessionRsp.from_obj = TInitSessionRsp_from_obj

TInitSessionRsp.proto_property = {'Result'}

TInitSessionRsp.default = {0}

TInitSessionRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TInitSessionRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Result', self.Result, 'int8', false, errs)

    TInitSessionRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInitSessionRsp.proto_property, errs)
    return self
end

function TInitSessionRsp:unpack(_)
    return self.Result
end

msg.InitSessionRsp = TInitSessionRsp

---@class SOL.InitSessionReq
---@field Mode integer
local TInitSessionReq = {}
TInitSessionReq.__index = TInitSessionReq
TInitSessionReq.group = {}

local function TInitSessionReq_from_obj(obj)
    return setmetatable(obj, TInitSessionReq)
end

function TInitSessionReq.new(Mode)
    return TInitSessionReq_from_obj({Mode = Mode})
end
---@param obj SOL.InitSessionReq
function TInitSessionReq:init_from_obj(obj)
    self.Mode = obj.Mode
end

function TInitSessionReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInitSessionReq.group)
end

TInitSessionReq.from_obj = TInitSessionReq_from_obj

TInitSessionReq.proto_property = {'Mode'}

TInitSessionReq.default = {0}

TInitSessionReq.struct = {{name = 'Mode', is_array = false, struct = nil}}

function TInitSessionReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Mode', self.Mode, 'uint8', false, errs)

    TInitSessionReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInitSessionReq.proto_property, errs)
    return self
end

function TInitSessionReq:unpack(_)
    return self.Mode
end

msg.InitSessionReq = TInitSessionReq

local SOL = {}

local Mdb = require 'mc.mdb'

---@class SOL: Table
---@field Enabled boolean
---@field Mode integer
---@field SerialDirect integer
---@field Timeout integer
SOL.SOL = Mdb.register_interface('bmc.kepler.Managers.SOL', {
    Enabled = {'b', nil, true, nil},
    Mode = {'y', nil, true, nil},
    SerialDirect = {'y', nil, true, nil},
    Timeout = {'q', nil, true, nil}
}, {
    InitSession = {'a{ss}y', 'y', msg.InitSessionReq, msg.InitSessionRsp},
    SetTimeout = {'a{ss}q', 'y', msg.SetTimeoutReq, msg.SetTimeoutRsp}
}, {})
return SOL
