-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class Session.DeactivateRsp
---@field Result integer
local TDeactivateRsp = {}
TDeactivateRsp.__index = TDeactivateRsp
TDeactivateRsp.group = {}

local function TDeactivateRsp_from_obj(obj)
    return setmetatable(obj, TDeactivateRsp)
end

function TDeactivateRsp.new(Result)
    return TDeactivateRsp_from_obj({Result = Result})
end
---@param obj Session.DeactivateRsp
function TDeactivateRsp:init_from_obj(obj)
    self.Result = obj.Result
end

function TDeactivateRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeactivateRsp.group)
end

TDeactivateRsp.from_obj = TDeactivateRsp_from_obj

TDeactivateRsp.proto_property = {'Result'}

TDeactivateRsp.default = {0}

TDeactivateRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TDeactivateRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Result', self.Result, 'int8', false, errs)

    TDeactivateRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeactivateRsp.proto_property, errs)
    return self
end

function TDeactivateRsp:unpack(_)
    return self.Result
end

msg.DeactivateRsp = TDeactivateRsp

---@class Session.DeactivateReq
local TDeactivateReq = {}
TDeactivateReq.__index = TDeactivateReq
TDeactivateReq.group = {}

local function TDeactivateReq_from_obj(obj)
    return setmetatable(obj, TDeactivateReq)
end

function TDeactivateReq.new()
    return TDeactivateReq_from_obj({})
end
---@param obj Session.DeactivateReq
function TDeactivateReq:init_from_obj(obj)

end

function TDeactivateReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeactivateReq.group)
end

TDeactivateReq.from_obj = TDeactivateReq_from_obj

TDeactivateReq.proto_property = {}

TDeactivateReq.default = {}

TDeactivateReq.struct = {}

function TDeactivateReq:validate(prefix, errs)
    prefix = prefix or ''

    TDeactivateReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeactivateReq.proto_property, errs)
    return self
end

function TDeactivateReq:unpack(_)
end

msg.DeactivateReq = TDeactivateReq

local Session = {}

local Mdb = require 'mc.mdb'

---@class Session: Table
---@field Activated boolean
---@field Type string
---@field ClientAddress string
---@field ActivatedTime string
---@field UserName string
Session.Session = Mdb.register_interface('bmc.kepler.Managers.SOL.Session', {
    Activated = {'b', nil, true, nil},
    Type = {'s', nil, true, nil},
    ClientAddress = {'s', nil, true, nil},
    ActivatedTime = {'s', nil, true, nil},
    UserName = {'s', nil, true, nil}
}, {Deactivate = {'a{ss}', 'y', msg.DeactivateReq, msg.DeactivateRsp}}, {})
return Session
