-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class Protocol.SetPortsRsp
local TSetPortsRsp = {}
TSetPortsRsp.__index = TSetPortsRsp
TSetPortsRsp.group = {}

local function TSetPortsRsp_from_obj(obj)
    return setmetatable(obj, TSetPortsRsp)
end

function TSetPortsRsp.new()
    return TSetPortsRsp_from_obj({})
end
---@param obj Protocol.SetPortsRsp
function TSetPortsRsp:init_from_obj(obj)

end

function TSetPortsRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPortsRsp.group)
end

TSetPortsRsp.from_obj = TSetPortsRsp_from_obj

TSetPortsRsp.proto_property = {}

TSetPortsRsp.default = {}

TSetPortsRsp.struct = {}

function TSetPortsRsp:validate(prefix, errs)
    prefix = prefix or ''

    TSetPortsRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPortsRsp.proto_property, errs)
    return self
end

function TSetPortsRsp:unpack(_)
end

msg.SetPortsRsp = TSetPortsRsp

---@class Protocol.SetPortsReq
---@field Ports integer[]
local TSetPortsReq = {}
TSetPortsReq.__index = TSetPortsReq
TSetPortsReq.group = {}

local function TSetPortsReq_from_obj(obj)
    return setmetatable(obj, TSetPortsReq)
end

function TSetPortsReq.new(Ports)
    return TSetPortsReq_from_obj({Ports = Ports})
end
---@param obj Protocol.SetPortsReq
function TSetPortsReq:init_from_obj(obj)
    self.Ports = obj.Ports
end

function TSetPortsReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPortsReq.group)
end

TSetPortsReq.from_obj = TSetPortsReq_from_obj

TSetPortsReq.proto_property = {'Ports'}

TSetPortsReq.default = {{}}

TSetPortsReq.struct = {{name = 'Ports', is_array = true, struct = nil}}

function TSetPortsReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.RequiredArray(prefix .. 'Ports', self.Ports, 'uint16', false, errs)

    TSetPortsReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPortsReq.proto_property, errs)
    return self
end

function TSetPortsReq:unpack(_)
    return self.Ports
end

msg.SetPortsReq = TSetPortsReq

local Protocol = {}

local Mdb = require 'mc.mdb'

---@class Protocol: Table
---@field Enabled boolean
---@field PortCount integer
---@field DefaultPort integer
---@field Port integer
---@field DefaultSparePort integer
---@field SparePort integer
Protocol.Protocol = Mdb.register_interface('bmc.kepler.Managers.NetworkProtocol.Protocol', {
    Enabled = {'b', nil, false, True},
    PortCount = {'y', nil, true, 0},
    DefaultPort = {'q', nil, true, 0},
    Port = {'q', nil, false, 0},
    DefaultSparePort = {'q', nil, true, 0},
    SparePort = {'q', nil, false, 0}
}, {SetPorts = {'a{ss}aq', '', msg.SetPortsReq, msg.SetPortsRsp}}, {})
return Protocol
