-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local LldpConfig = {}

local Mdb = require 'mc.mdb'

---@class LldpConfig: Table
---@field Enabled boolean
---@field WorkMode string
---@field TxDelaySeconds integer
---@field TxIntervalSeconds integer
---@field TxHold integer
LldpConfig.LldpConfig = Mdb.register_interface('bmc.kepler.Managers.LldpConfig', {
    Enabled = {'b', nil, false, nil},
    WorkMode = {'s', nil, false, nil},
    TxDelaySeconds = {'i', nil, false, nil},
    TxIntervalSeconds = {'i', nil, false, nil},
    TxHold = {'i', nil, false, nil}
}, {}, {})
return LldpConfig
