-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class defs.Port
---@field Id integer
---@field EthId integer
---@field DeviceId integer
---@field DevicePortId integer
---@field Silkscreen string
---@field Type string
---@field AdaptiveFlag boolean
---@field LinkStatus string
---@field Mac string
local TPort = {}
TPort.__index = TPort
TPort.group = {}

local function TPort_from_obj(obj)
    return setmetatable(obj, TPort)
end

function TPort.new(Id, EthId, DeviceId, DevicePortId, Silkscreen, Type, AdaptiveFlag, LinkStatus,
    Mac)
    return TPort_from_obj({
        Id = Id,
        EthId = EthId,
        DeviceId = DeviceId,
        DevicePortId = DevicePortId,
        Silkscreen = Silkscreen,
        Type = Type,
        AdaptiveFlag = AdaptiveFlag,
        LinkStatus = LinkStatus,
        Mac = Mac
    })
end
---@param obj defs.Port
function TPort:init_from_obj(obj)
    self.Id = obj.Id
    self.EthId = obj.EthId
    self.DeviceId = obj.DeviceId
    self.DevicePortId = obj.DevicePortId
    self.Silkscreen = obj.Silkscreen
    self.Type = obj.Type
    self.AdaptiveFlag = obj.AdaptiveFlag
    self.LinkStatus = obj.LinkStatus
    self.Mac = obj.Mac
end

function TPort:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPort.group)
end

TPort.from_obj = TPort_from_obj

TPort.proto_property = {
    'Id', 'EthId', 'DeviceId', 'DevicePortId', 'Silkscreen', 'Type', 'AdaptiveFlag', 'LinkStatus',
    'Mac'
}

TPort.default = {0, 0, 0, 0, '', '', false, '', ''}

TPort.struct = {
    {name = 'Id', is_array = false, struct = nil}, {name = 'EthId', is_array = false, struct = nil},
    {name = 'DeviceId', is_array = false, struct = nil},
    {name = 'DevicePortId', is_array = false, struct = nil},
    {name = 'Silkscreen', is_array = false, struct = nil},
    {name = 'Type', is_array = false, struct = nil},
    {name = 'AdaptiveFlag', is_array = false, struct = nil},
    {name = 'LinkStatus', is_array = false, struct = nil},
    {name = 'Mac', is_array = false, struct = nil}
}

function TPort:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Id', self.Id, 'uint8', false, errs)
    validate.Required(prefix .. 'EthId', self.EthId, 'uint8', false, errs)
    validate.Required(prefix .. 'DeviceId', self.DeviceId, 'uint8', false, errs)
    validate.Required(prefix .. 'DevicePortId', self.DevicePortId, 'uint8', false, errs)
    validate.Required(prefix .. 'Silkscreen', self.Silkscreen, 'string', false, errs)
    validate.Required(prefix .. 'Type', self.Type, 'string', false, errs)
    validate.Required(prefix .. 'AdaptiveFlag', self.AdaptiveFlag, 'bool', false, errs)
    validate.Required(prefix .. 'LinkStatus', self.LinkStatus, 'string', false, errs)
    validate.Required(prefix .. 'Mac', self.Mac, 'string', false, errs)

    TPort:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPort.proto_property, errs)
    return self
end

function TPort:unpack(_)
    return self.Id, self.EthId, self.DeviceId, self.DevicePortId, self.Silkscreen, self.Type,
        self.AdaptiveFlag, self.LinkStatus, self.Mac
end

defs.Port = TPort

---@class EthernetInterfaces.AddMgmtPortRsp
---@field PortId integer
local TAddMgmtPortRsp = {}
TAddMgmtPortRsp.__index = TAddMgmtPortRsp
TAddMgmtPortRsp.group = {}

local function TAddMgmtPortRsp_from_obj(obj)
    return setmetatable(obj, TAddMgmtPortRsp)
end

function TAddMgmtPortRsp.new(PortId)
    return TAddMgmtPortRsp_from_obj({PortId = PortId})
end
---@param obj EthernetInterfaces.AddMgmtPortRsp
function TAddMgmtPortRsp:init_from_obj(obj)
    self.PortId = obj.PortId
end

function TAddMgmtPortRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAddMgmtPortRsp.group)
end

TAddMgmtPortRsp.from_obj = TAddMgmtPortRsp_from_obj

TAddMgmtPortRsp.proto_property = {'PortId'}

TAddMgmtPortRsp.default = {0}

TAddMgmtPortRsp.struct = {{name = 'PortId', is_array = false, struct = nil}}

function TAddMgmtPortRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'PortId', self.PortId, 'uint8', false, errs)

    TAddMgmtPortRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAddMgmtPortRsp.proto_property, errs)
    return self
end

function TAddMgmtPortRsp:unpack(_)
    return self.PortId
end

msg.AddMgmtPortRsp = TAddMgmtPortRsp

---@class EthernetInterfaces.AddMgmtPortReq
---@field DeviceId integer
---@field DevicePortId integer
---@field Silkscreen string
---@field EthId integer
---@field Type string
---@field PortId integer
local TAddMgmtPortReq = {}
TAddMgmtPortReq.__index = TAddMgmtPortReq
TAddMgmtPortReq.group = {}

local function TAddMgmtPortReq_from_obj(obj)
    return setmetatable(obj, TAddMgmtPortReq)
end

function TAddMgmtPortReq.new(DeviceId, DevicePortId, Silkscreen, EthId, Type, PortId)
    return TAddMgmtPortReq_from_obj({
        DeviceId = DeviceId,
        DevicePortId = DevicePortId,
        Silkscreen = Silkscreen,
        EthId = EthId,
        Type = Type,
        PortId = PortId
    })
end
---@param obj EthernetInterfaces.AddMgmtPortReq
function TAddMgmtPortReq:init_from_obj(obj)
    self.DeviceId = obj.DeviceId
    self.DevicePortId = obj.DevicePortId
    self.Silkscreen = obj.Silkscreen
    self.EthId = obj.EthId
    self.Type = obj.Type
    self.PortId = obj.PortId
end

function TAddMgmtPortReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAddMgmtPortReq.group)
end

TAddMgmtPortReq.from_obj = TAddMgmtPortReq_from_obj

TAddMgmtPortReq.proto_property = {
    'DeviceId', 'DevicePortId', 'Silkscreen', 'EthId', 'Type', 'PortId'
}

TAddMgmtPortReq.default = {0, 0, '', 0, '', 0}

TAddMgmtPortReq.struct = {
    {name = 'DeviceId', is_array = false, struct = nil},
    {name = 'DevicePortId', is_array = false, struct = nil},
    {name = 'Silkscreen', is_array = false, struct = nil},
    {name = 'EthId', is_array = false, struct = nil},
    {name = 'Type', is_array = false, struct = nil},
    {name = 'PortId', is_array = false, struct = nil}
}

function TAddMgmtPortReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'DeviceId', self.DeviceId, 'uint8', false, errs)
    validate.Required(prefix .. 'DevicePortId', self.DevicePortId, 'uint8', false, errs)
    validate.Required(prefix .. 'Silkscreen', self.Silkscreen, 'string', false, errs)
    validate.Required(prefix .. 'EthId', self.EthId, 'uint8', false, errs)
    validate.Required(prefix .. 'Type', self.Type, 'string', false, errs)
    validate.Required(prefix .. 'PortId', self.PortId, 'uint8', false, errs)

    TAddMgmtPortReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAddMgmtPortReq.proto_property, errs)
    return self
end

function TAddMgmtPortReq:unpack(_)
    return self.DeviceId, self.DevicePortId, self.Silkscreen, self.EthId, self.Type, self.PortId
end

msg.AddMgmtPortReq = TAddMgmtPortReq

---@class EthernetInterfaces.SetNetworkConfigRsp
local TSetNetworkConfigRsp = {}
TSetNetworkConfigRsp.__index = TSetNetworkConfigRsp
TSetNetworkConfigRsp.group = {}

local function TSetNetworkConfigRsp_from_obj(obj)
    return setmetatable(obj, TSetNetworkConfigRsp)
end

function TSetNetworkConfigRsp.new()
    return TSetNetworkConfigRsp_from_obj({})
end
---@param obj EthernetInterfaces.SetNetworkConfigRsp
function TSetNetworkConfigRsp:init_from_obj(obj)

end

function TSetNetworkConfigRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetNetworkConfigRsp.group)
end

TSetNetworkConfigRsp.from_obj = TSetNetworkConfigRsp_from_obj

TSetNetworkConfigRsp.proto_property = {}

TSetNetworkConfigRsp.default = {}

TSetNetworkConfigRsp.struct = {}

function TSetNetworkConfigRsp:validate(prefix, errs)
    prefix = prefix or ''

    TSetNetworkConfigRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetNetworkConfigRsp.proto_property, errs)
    return self
end

function TSetNetworkConfigRsp:unpack(_)
end

msg.SetNetworkConfigRsp = TSetNetworkConfigRsp

---@class EthernetInterfaces.SetNetworkConfigReq
---@field NetMode string
---@field PortId integer
---@field VLANEnable boolean
---@field VLANId integer
local TSetNetworkConfigReq = {}
TSetNetworkConfigReq.__index = TSetNetworkConfigReq
TSetNetworkConfigReq.group = {}

local function TSetNetworkConfigReq_from_obj(obj)
    return setmetatable(obj, TSetNetworkConfigReq)
end

function TSetNetworkConfigReq.new(NetMode, PortId, VLANEnable, VLANId)
    return TSetNetworkConfigReq_from_obj({
        NetMode = NetMode,
        PortId = PortId,
        VLANEnable = VLANEnable,
        VLANId = VLANId
    })
end
---@param obj EthernetInterfaces.SetNetworkConfigReq
function TSetNetworkConfigReq:init_from_obj(obj)
    self.NetMode = obj.NetMode
    self.PortId = obj.PortId
    self.VLANEnable = obj.VLANEnable
    self.VLANId = obj.VLANId
end

function TSetNetworkConfigReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetNetworkConfigReq.group)
end

TSetNetworkConfigReq.from_obj = TSetNetworkConfigReq_from_obj

TSetNetworkConfigReq.proto_property = {'NetMode', 'PortId', 'VLANEnable', 'VLANId'}

TSetNetworkConfigReq.default = {'', 0, false, 0}

TSetNetworkConfigReq.struct = {
    {name = 'NetMode', is_array = false, struct = nil},
    {name = 'PortId', is_array = false, struct = nil},
    {name = 'VLANEnable', is_array = false, struct = nil},
    {name = 'VLANId', is_array = false, struct = nil}
}

function TSetNetworkConfigReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'NetMode', self.NetMode, 'string', false, errs)
    validate.Required(prefix .. 'PortId', self.PortId, 'uint8', false, errs)
    validate.Required(prefix .. 'VLANEnable', self.VLANEnable, 'bool', false, errs)
    validate.Required(prefix .. 'VLANId', self.VLANId, 'uint16', false, errs)

    TSetNetworkConfigReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetNetworkConfigReq.proto_property, errs)
    return self
end

function TSetNetworkConfigReq:unpack(_)
    return self.NetMode, self.PortId, self.VLANEnable, self.VLANId
end

msg.SetNetworkConfigReq = TSetNetworkConfigReq

---@class EthernetInterfaces.GetAllPortRsp
---@field Port defs.Port[]
local TGetAllPortRsp = {}
TGetAllPortRsp.__index = TGetAllPortRsp
TGetAllPortRsp.group = {}

local function TGetAllPortRsp_from_obj(obj)
    obj.Port = utils.from_obj(defs.Port, obj.Port, true)
    return setmetatable(obj, TGetAllPortRsp)
end

function TGetAllPortRsp.new(Port)
    return TGetAllPortRsp_from_obj({Port = Port})
end
---@param obj EthernetInterfaces.GetAllPortRsp
function TGetAllPortRsp:init_from_obj(obj)
    self.Port = obj.Port
end

function TGetAllPortRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetAllPortRsp.group)
end

TGetAllPortRsp.from_obj = TGetAllPortRsp_from_obj

TGetAllPortRsp.proto_property = {'Port'}

TGetAllPortRsp.default = {{}}

TGetAllPortRsp.struct = {{name = 'Port', is_array = true, struct = defs.Port.struct}}

function TGetAllPortRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.RequiredArray(prefix .. 'Port', self.Port, 'defs.Port', false, errs)

    TGetAllPortRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetAllPortRsp.proto_property, errs)
    return self
end

function TGetAllPortRsp:unpack(raw)
    return utils.unpack(raw, self.Port, true)
end

msg.GetAllPortRsp = TGetAllPortRsp

---@class EthernetInterfaces.GetAllPortReq
local TGetAllPortReq = {}
TGetAllPortReq.__index = TGetAllPortReq
TGetAllPortReq.group = {}

local function TGetAllPortReq_from_obj(obj)
    return setmetatable(obj, TGetAllPortReq)
end

function TGetAllPortReq.new()
    return TGetAllPortReq_from_obj({})
end
---@param obj EthernetInterfaces.GetAllPortReq
function TGetAllPortReq:init_from_obj(obj)

end

function TGetAllPortReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetAllPortReq.group)
end

TGetAllPortReq.from_obj = TGetAllPortReq_from_obj

TGetAllPortReq.proto_property = {}

TGetAllPortReq.default = {}

TGetAllPortReq.struct = {}

function TGetAllPortReq:validate(prefix, errs)
    prefix = prefix or ''

    TGetAllPortReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetAllPortReq.proto_property, errs)
    return self
end

function TGetAllPortReq:unpack(_)
end

msg.GetAllPortReq = TGetAllPortReq

local EthernetInterfaces = {}

local Mdb = require 'mc.mdb'

---@class EthernetInterfaces: Table
---@field EthName string
---@field NetMode string
---@field Mac string
---@field IpVersion string
---@field NcsiEnable boolean
---@field PortId integer
---@field VLANEnable boolean
---@field VLANId integer
EthernetInterfaces.EthernetInterfaces = Mdb.register_interface(
    'bmc.kepler.Managers.EthernetInterfaces', {
        EthName = {'s', nil, true, nil},
        NetMode = {'s', nil, false, nil},
        Mac = {'s', nil, true, nil},
        IpVersion = {'s', nil, false, nil},
        NcsiEnable = {'b', nil, true, nil},
        PortId = {'y', nil, true, nil},
        VLANEnable = {'b', nil, true, nil},
        VLANId = {'q', nil, true, nil}
    }, {
        GetAllPort = {'a{ss}', 'a(yyyyssbss)', msg.GetAllPortReq, msg.GetAllPortRsp},
        SetNetworkConfig = {'a{ss}sybq', '', msg.SetNetworkConfigReq, msg.SetNetworkConfigRsp},
        AddMgmtPort = {'a{ss}yysysy', 'y', msg.AddMgmtPortReq, msg.AddMgmtPortRsp}
    }, {})
return EthernetInterfaces
