-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local MgmtPort = {}

local Mdb = require 'mc.mdb'

---@class MgmtPort: Table
---@field Id integer
---@field EthId integer
---@field DeviceId integer
---@field DevicePortId integer
---@field Silkscreen string
---@field Type string
---@field AdaptiveFlag boolean
---@field LinkStatus string
---@field Mac string
MgmtPort.MgmtPort = Mdb.register_interface('bmc.kepler.Managers.EthernetInterfaces.MgmtPort', {
    Id = {'y', nil, true, nil},
    EthId = {'y', nil, true, nil},
    DeviceId = {'y', nil, true, nil},
    DevicePortId = {'y', nil, true, nil},
    Silkscreen = {'s', nil, true, nil},
    Type = {'s', nil, true, nil},
    AdaptiveFlag = {'b', nil, false, nil},
    LinkStatus = {'s', nil, false, nil},
    Mac = {'s', nil, true, nil}
}, {}, {})
return MgmtPort
