-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class Ipv6.SetIpv6PrefixGatewayRsp
---@field IpAddr string
local TSetIpv6PrefixGatewayRsp = {}
TSetIpv6PrefixGatewayRsp.__index = TSetIpv6PrefixGatewayRsp
TSetIpv6PrefixGatewayRsp.group = {}

local function TSetIpv6PrefixGatewayRsp_from_obj(obj)
    return setmetatable(obj, TSetIpv6PrefixGatewayRsp)
end

function TSetIpv6PrefixGatewayRsp.new(IpAddr)
    return TSetIpv6PrefixGatewayRsp_from_obj({IpAddr = IpAddr})
end
---@param obj Ipv6.SetIpv6PrefixGatewayRsp
function TSetIpv6PrefixGatewayRsp:init_from_obj(obj)
    self.IpAddr = obj.IpAddr
end

function TSetIpv6PrefixGatewayRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetIpv6PrefixGatewayRsp.group)
end

TSetIpv6PrefixGatewayRsp.from_obj = TSetIpv6PrefixGatewayRsp_from_obj

TSetIpv6PrefixGatewayRsp.proto_property = {'IpAddr'}

TSetIpv6PrefixGatewayRsp.default = {''}

TSetIpv6PrefixGatewayRsp.struct = {{name = 'IpAddr', is_array = false, struct = nil}}

function TSetIpv6PrefixGatewayRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'IpAddr', self.IpAddr, 'string', false, errs)

    TSetIpv6PrefixGatewayRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetIpv6PrefixGatewayRsp.proto_property, errs)
    return self
end

function TSetIpv6PrefixGatewayRsp:unpack(_)
    return self.IpAddr
end

msg.SetIpv6PrefixGatewayRsp = TSetIpv6PrefixGatewayRsp

---@class Ipv6.SetIpv6PrefixGatewayReq
---@field IpAddr string
---@field PrefixLength integer
---@field DefaultGateway string
local TSetIpv6PrefixGatewayReq = {}
TSetIpv6PrefixGatewayReq.__index = TSetIpv6PrefixGatewayReq
TSetIpv6PrefixGatewayReq.group = {}

local function TSetIpv6PrefixGatewayReq_from_obj(obj)
    return setmetatable(obj, TSetIpv6PrefixGatewayReq)
end

function TSetIpv6PrefixGatewayReq.new(IpAddr, PrefixLength, DefaultGateway)
    return TSetIpv6PrefixGatewayReq_from_obj({
        IpAddr = IpAddr,
        PrefixLength = PrefixLength,
        DefaultGateway = DefaultGateway
    })
end
---@param obj Ipv6.SetIpv6PrefixGatewayReq
function TSetIpv6PrefixGatewayReq:init_from_obj(obj)
    self.IpAddr = obj.IpAddr
    self.PrefixLength = obj.PrefixLength
    self.DefaultGateway = obj.DefaultGateway
end

function TSetIpv6PrefixGatewayReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetIpv6PrefixGatewayReq.group)
end

TSetIpv6PrefixGatewayReq.from_obj = TSetIpv6PrefixGatewayReq_from_obj

TSetIpv6PrefixGatewayReq.proto_property = {'IpAddr', 'PrefixLength', 'DefaultGateway'}

TSetIpv6PrefixGatewayReq.default = {'', 0, ''}

TSetIpv6PrefixGatewayReq.struct = {
    {name = 'IpAddr', is_array = false, struct = nil},
    {name = 'PrefixLength', is_array = false, struct = nil},
    {name = 'DefaultGateway', is_array = false, struct = nil}
}

function TSetIpv6PrefixGatewayReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'IpAddr', self.IpAddr, 'string', false, errs)
    validate.Required(prefix .. 'PrefixLength', self.PrefixLength, 'int32', false, errs)
    validate.Required(prefix .. 'DefaultGateway', self.DefaultGateway, 'string', false, errs)

    TSetIpv6PrefixGatewayReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetIpv6PrefixGatewayReq.proto_property, errs)
    return self
end

function TSetIpv6PrefixGatewayReq:unpack(_)
    return self.IpAddr, self.PrefixLength, self.DefaultGateway
end

msg.SetIpv6PrefixGatewayReq = TSetIpv6PrefixGatewayReq

local Ipv6 = {}

local Mdb = require 'mc.mdb'

---@class Ipv6: Table
---@field IpMode string
---@field IpAddr string
---@field PrefixLength integer
---@field Scope string
---@field DefaultGateway string
Ipv6.Ipv6 = Mdb.register_interface('bmc.kepler.Managers.EthernetInterfaces.Ipv6', {
    IpMode = {'s', nil, false, nil},
    IpAddr = {'s', nil, true, nil},
    PrefixLength = {'i', nil, true, nil},
    Scope = {'s', nil, true, nil},
    DefaultGateway = {'s', nil, true, nil}
}, {
    SetIpv6PrefixGateway = {
        'a{ss}sis', 's', msg.SetIpv6PrefixGatewayReq, msg.SetIpv6PrefixGatewayRsp
    }
}, {})
return Ipv6
