-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class DNS.SetDHCPUseDNSServersRsp
local TSetDHCPUseDNSServersRsp = {}
TSetDHCPUseDNSServersRsp.__index = TSetDHCPUseDNSServersRsp
TSetDHCPUseDNSServersRsp.group = {}

local function TSetDHCPUseDNSServersRsp_from_obj(obj)
    return setmetatable(obj, TSetDHCPUseDNSServersRsp)
end

function TSetDHCPUseDNSServersRsp.new()
    return TSetDHCPUseDNSServersRsp_from_obj({})
end
---@param obj DNS.SetDHCPUseDNSServersRsp
function TSetDHCPUseDNSServersRsp:init_from_obj(obj)

end

function TSetDHCPUseDNSServersRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDHCPUseDNSServersRsp.group)
end

TSetDHCPUseDNSServersRsp.from_obj = TSetDHCPUseDNSServersRsp_from_obj

TSetDHCPUseDNSServersRsp.proto_property = {}

TSetDHCPUseDNSServersRsp.default = {}

TSetDHCPUseDNSServersRsp.struct = {}

function TSetDHCPUseDNSServersRsp:validate(prefix, errs)
    prefix = prefix or ''

    TSetDHCPUseDNSServersRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDHCPUseDNSServersRsp.proto_property, errs)
    return self
end

function TSetDHCPUseDNSServersRsp:unpack(_)
end

msg.SetDHCPUseDNSServersRsp = TSetDHCPUseDNSServersRsp

---@class DNS.SetDHCPUseDNSServersReq
---@field DHCPVersion integer
---@field State integer
local TSetDHCPUseDNSServersReq = {}
TSetDHCPUseDNSServersReq.__index = TSetDHCPUseDNSServersReq
TSetDHCPUseDNSServersReq.group = {}

local function TSetDHCPUseDNSServersReq_from_obj(obj)
    return setmetatable(obj, TSetDHCPUseDNSServersReq)
end

function TSetDHCPUseDNSServersReq.new(DHCPVersion, State)
    return TSetDHCPUseDNSServersReq_from_obj({DHCPVersion = DHCPVersion, State = State})
end
---@param obj DNS.SetDHCPUseDNSServersReq
function TSetDHCPUseDNSServersReq:init_from_obj(obj)
    self.DHCPVersion = obj.DHCPVersion
    self.State = obj.State
end

function TSetDHCPUseDNSServersReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDHCPUseDNSServersReq.group)
end

TSetDHCPUseDNSServersReq.from_obj = TSetDHCPUseDNSServersReq_from_obj

TSetDHCPUseDNSServersReq.proto_property = {'DHCPVersion', 'State'}

TSetDHCPUseDNSServersReq.default = {0, 0}

TSetDHCPUseDNSServersReq.struct = {
    {name = 'DHCPVersion', is_array = false, struct = nil},
    {name = 'State', is_array = false, struct = nil}
}

function TSetDHCPUseDNSServersReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'DHCPVersion', self.DHCPVersion, 'uint16', false, errs)
    validate.Required(prefix .. 'State', self.State, 'uint8', false, errs)

    TSetDHCPUseDNSServersReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDHCPUseDNSServersReq.proto_property, errs)
    return self
end

function TSetDHCPUseDNSServersReq:unpack(_)
    return self.DHCPVersion, self.State
end

msg.SetDHCPUseDNSServersReq = TSetDHCPUseDNSServersReq

---@class DNS.SetTertiaryNameServerRsp
local TSetTertiaryNameServerRsp = {}
TSetTertiaryNameServerRsp.__index = TSetTertiaryNameServerRsp
TSetTertiaryNameServerRsp.group = {}

local function TSetTertiaryNameServerRsp_from_obj(obj)
    return setmetatable(obj, TSetTertiaryNameServerRsp)
end

function TSetTertiaryNameServerRsp.new()
    return TSetTertiaryNameServerRsp_from_obj({})
end
---@param obj DNS.SetTertiaryNameServerRsp
function TSetTertiaryNameServerRsp:init_from_obj(obj)

end

function TSetTertiaryNameServerRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetTertiaryNameServerRsp.group)
end

TSetTertiaryNameServerRsp.from_obj = TSetTertiaryNameServerRsp_from_obj

TSetTertiaryNameServerRsp.proto_property = {}

TSetTertiaryNameServerRsp.default = {}

TSetTertiaryNameServerRsp.struct = {}

function TSetTertiaryNameServerRsp:validate(prefix, errs)
    prefix = prefix or ''

    TSetTertiaryNameServerRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetTertiaryNameServerRsp.proto_property, errs)
    return self
end

function TSetTertiaryNameServerRsp:unpack(_)
end

msg.SetTertiaryNameServerRsp = TSetTertiaryNameServerRsp

---@class DNS.SetTertiaryNameServerReq
---@field IpAddr string
local TSetTertiaryNameServerReq = {}
TSetTertiaryNameServerReq.__index = TSetTertiaryNameServerReq
TSetTertiaryNameServerReq.group = {}

local function TSetTertiaryNameServerReq_from_obj(obj)
    return setmetatable(obj, TSetTertiaryNameServerReq)
end

function TSetTertiaryNameServerReq.new(IpAddr)
    return TSetTertiaryNameServerReq_from_obj({IpAddr = IpAddr})
end
---@param obj DNS.SetTertiaryNameServerReq
function TSetTertiaryNameServerReq:init_from_obj(obj)
    self.IpAddr = obj.IpAddr
end

function TSetTertiaryNameServerReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetTertiaryNameServerReq.group)
end

TSetTertiaryNameServerReq.from_obj = TSetTertiaryNameServerReq_from_obj

TSetTertiaryNameServerReq.proto_property = {'IpAddr'}

TSetTertiaryNameServerReq.default = {''}

TSetTertiaryNameServerReq.struct = {{name = 'IpAddr', is_array = false, struct = nil}}

function TSetTertiaryNameServerReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'IpAddr', self.IpAddr, 'string', false, errs)

    TSetTertiaryNameServerReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetTertiaryNameServerReq.proto_property, errs)
    return self
end

function TSetTertiaryNameServerReq:unpack(_)
    return self.IpAddr
end

msg.SetTertiaryNameServerReq = TSetTertiaryNameServerReq

---@class DNS.SetBackupNameServerRsp
local TSetBackupNameServerRsp = {}
TSetBackupNameServerRsp.__index = TSetBackupNameServerRsp
TSetBackupNameServerRsp.group = {}

local function TSetBackupNameServerRsp_from_obj(obj)
    return setmetatable(obj, TSetBackupNameServerRsp)
end

function TSetBackupNameServerRsp.new()
    return TSetBackupNameServerRsp_from_obj({})
end
---@param obj DNS.SetBackupNameServerRsp
function TSetBackupNameServerRsp:init_from_obj(obj)

end

function TSetBackupNameServerRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBackupNameServerRsp.group)
end

TSetBackupNameServerRsp.from_obj = TSetBackupNameServerRsp_from_obj

TSetBackupNameServerRsp.proto_property = {}

TSetBackupNameServerRsp.default = {}

TSetBackupNameServerRsp.struct = {}

function TSetBackupNameServerRsp:validate(prefix, errs)
    prefix = prefix or ''

    TSetBackupNameServerRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBackupNameServerRsp.proto_property, errs)
    return self
end

function TSetBackupNameServerRsp:unpack(_)
end

msg.SetBackupNameServerRsp = TSetBackupNameServerRsp

---@class DNS.SetBackupNameServerReq
---@field IpAddr string
local TSetBackupNameServerReq = {}
TSetBackupNameServerReq.__index = TSetBackupNameServerReq
TSetBackupNameServerReq.group = {}

local function TSetBackupNameServerReq_from_obj(obj)
    return setmetatable(obj, TSetBackupNameServerReq)
end

function TSetBackupNameServerReq.new(IpAddr)
    return TSetBackupNameServerReq_from_obj({IpAddr = IpAddr})
end
---@param obj DNS.SetBackupNameServerReq
function TSetBackupNameServerReq:init_from_obj(obj)
    self.IpAddr = obj.IpAddr
end

function TSetBackupNameServerReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBackupNameServerReq.group)
end

TSetBackupNameServerReq.from_obj = TSetBackupNameServerReq_from_obj

TSetBackupNameServerReq.proto_property = {'IpAddr'}

TSetBackupNameServerReq.default = {''}

TSetBackupNameServerReq.struct = {{name = 'IpAddr', is_array = false, struct = nil}}

function TSetBackupNameServerReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'IpAddr', self.IpAddr, 'string', false, errs)

    TSetBackupNameServerReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBackupNameServerReq.proto_property, errs)
    return self
end

function TSetBackupNameServerReq:unpack(_)
    return self.IpAddr
end

msg.SetBackupNameServerReq = TSetBackupNameServerReq

---@class DNS.SetPrimaryNameServerRsp
local TSetPrimaryNameServerRsp = {}
TSetPrimaryNameServerRsp.__index = TSetPrimaryNameServerRsp
TSetPrimaryNameServerRsp.group = {}

local function TSetPrimaryNameServerRsp_from_obj(obj)
    return setmetatable(obj, TSetPrimaryNameServerRsp)
end

function TSetPrimaryNameServerRsp.new()
    return TSetPrimaryNameServerRsp_from_obj({})
end
---@param obj DNS.SetPrimaryNameServerRsp
function TSetPrimaryNameServerRsp:init_from_obj(obj)

end

function TSetPrimaryNameServerRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPrimaryNameServerRsp.group)
end

TSetPrimaryNameServerRsp.from_obj = TSetPrimaryNameServerRsp_from_obj

TSetPrimaryNameServerRsp.proto_property = {}

TSetPrimaryNameServerRsp.default = {}

TSetPrimaryNameServerRsp.struct = {}

function TSetPrimaryNameServerRsp:validate(prefix, errs)
    prefix = prefix or ''

    TSetPrimaryNameServerRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPrimaryNameServerRsp.proto_property, errs)
    return self
end

function TSetPrimaryNameServerRsp:unpack(_)
end

msg.SetPrimaryNameServerRsp = TSetPrimaryNameServerRsp

---@class DNS.SetPrimaryNameServerReq
---@field IpAddr string
local TSetPrimaryNameServerReq = {}
TSetPrimaryNameServerReq.__index = TSetPrimaryNameServerReq
TSetPrimaryNameServerReq.group = {}

local function TSetPrimaryNameServerReq_from_obj(obj)
    return setmetatable(obj, TSetPrimaryNameServerReq)
end

function TSetPrimaryNameServerReq.new(IpAddr)
    return TSetPrimaryNameServerReq_from_obj({IpAddr = IpAddr})
end
---@param obj DNS.SetPrimaryNameServerReq
function TSetPrimaryNameServerReq:init_from_obj(obj)
    self.IpAddr = obj.IpAddr
end

function TSetPrimaryNameServerReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPrimaryNameServerReq.group)
end

TSetPrimaryNameServerReq.from_obj = TSetPrimaryNameServerReq_from_obj

TSetPrimaryNameServerReq.proto_property = {'IpAddr'}

TSetPrimaryNameServerReq.default = {''}

TSetPrimaryNameServerReq.struct = {{name = 'IpAddr', is_array = false, struct = nil}}

function TSetPrimaryNameServerReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'IpAddr', self.IpAddr, 'string', false, errs)

    TSetPrimaryNameServerReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPrimaryNameServerReq.proto_property, errs)
    return self
end

function TSetPrimaryNameServerReq:unpack(_)
    return self.IpAddr
end

msg.SetPrimaryNameServerReq = TSetPrimaryNameServerReq

local DNS = {}

local Mdb = require 'mc.mdb'

---@class DNS: Table
---@field PrimaryNameServer string
---@field BackupNameServer string
---@field TertiaryNameServer string
---@field DHCPv4UseDNSServers boolean
---@field DHCPv6UseDNSServers boolean
DNS.DNS = Mdb.register_interface('bmc.kepler.Managers.EthernetInterfaces.DNS', {
    PrimaryNameServer = {'s', nil, false, nil},
    BackupNameServer = {'s', nil, false, nil},
    TertiaryNameServer = {'s', nil, false, nil},
    DHCPv4UseDNSServers = {'b', nil, false, nil},
    DHCPv6UseDNSServers = {'b', nil, false, nil}
}, {
    SetPrimaryNameServer = {'a{ss}s', '', msg.SetPrimaryNameServerReq, msg.SetPrimaryNameServerRsp},
    SetBackupNameServer = {'a{ss}s', '', msg.SetBackupNameServerReq, msg.SetBackupNameServerRsp},
    SetTertiaryNameServer = {
        'a{ss}s', '', msg.SetTertiaryNameServerReq, msg.SetTertiaryNameServerRsp
    },
    SetDHCPUseDNSServers = {'a{ss}qy', '', msg.SetDHCPUseDNSServersReq, msg.SetDHCPUseDNSServersRsp}
}, {})
return DNS
