-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class Configurations.RecoverCustomRestorePointRsp
---@field TaskId integer
local TRecoverCustomRestorePointRsp = {}
TRecoverCustomRestorePointRsp.__index = TRecoverCustomRestorePointRsp
TRecoverCustomRestorePointRsp.group = {}

local function TRecoverCustomRestorePointRsp_from_obj(obj)
    return setmetatable(obj, TRecoverCustomRestorePointRsp)
end

function TRecoverCustomRestorePointRsp.new(TaskId)
    return TRecoverCustomRestorePointRsp_from_obj({TaskId = TaskId})
end
---@param obj Configurations.RecoverCustomRestorePointRsp
function TRecoverCustomRestorePointRsp:init_from_obj(obj)
    self.TaskId = obj.TaskId
end

function TRecoverCustomRestorePointRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRecoverCustomRestorePointRsp.group)
end

TRecoverCustomRestorePointRsp.from_obj = TRecoverCustomRestorePointRsp_from_obj

TRecoverCustomRestorePointRsp.proto_property = {'TaskId'}

TRecoverCustomRestorePointRsp.default = {0}

TRecoverCustomRestorePointRsp.struct = {{name = 'TaskId', is_array = false, struct = nil}}

function TRecoverCustomRestorePointRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TaskId', self.TaskId, 'uint32', false, errs)

    if self.TaskId ~= nil then
    end

    TRecoverCustomRestorePointRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRecoverCustomRestorePointRsp.proto_property, errs)
    return self
end

function TRecoverCustomRestorePointRsp:unpack(_)
    return self.TaskId
end

msg.RecoverCustomRestorePointRsp = TRecoverCustomRestorePointRsp

---@class Configurations.RecoverCustomRestorePointReq
local TRecoverCustomRestorePointReq = {}
TRecoverCustomRestorePointReq.__index = TRecoverCustomRestorePointReq
TRecoverCustomRestorePointReq.group = {}

local function TRecoverCustomRestorePointReq_from_obj(obj)
    return setmetatable(obj, TRecoverCustomRestorePointReq)
end

function TRecoverCustomRestorePointReq.new()
    return TRecoverCustomRestorePointReq_from_obj({})
end
---@param obj Configurations.RecoverCustomRestorePointReq
function TRecoverCustomRestorePointReq:init_from_obj(obj)

end

function TRecoverCustomRestorePointReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRecoverCustomRestorePointReq.group)
end

TRecoverCustomRestorePointReq.from_obj = TRecoverCustomRestorePointReq_from_obj

TRecoverCustomRestorePointReq.proto_property = {}

TRecoverCustomRestorePointReq.default = {}

TRecoverCustomRestorePointReq.struct = {}

function TRecoverCustomRestorePointReq:validate(prefix, errs)
    prefix = prefix or ''

    TRecoverCustomRestorePointReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRecoverCustomRestorePointReq.proto_property, errs)
    return self
end

function TRecoverCustomRestorePointReq:unpack(_)
end

msg.RecoverCustomRestorePointReq = TRecoverCustomRestorePointReq

---@class Configurations.RecoverFactoryRestorePointRsp
---@field TaskId integer
local TRecoverFactoryRestorePointRsp = {}
TRecoverFactoryRestorePointRsp.__index = TRecoverFactoryRestorePointRsp
TRecoverFactoryRestorePointRsp.group = {}

local function TRecoverFactoryRestorePointRsp_from_obj(obj)
    return setmetatable(obj, TRecoverFactoryRestorePointRsp)
end

function TRecoverFactoryRestorePointRsp.new(TaskId)
    return TRecoverFactoryRestorePointRsp_from_obj({TaskId = TaskId})
end
---@param obj Configurations.RecoverFactoryRestorePointRsp
function TRecoverFactoryRestorePointRsp:init_from_obj(obj)
    self.TaskId = obj.TaskId
end

function TRecoverFactoryRestorePointRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRecoverFactoryRestorePointRsp.group)
end

TRecoverFactoryRestorePointRsp.from_obj = TRecoverFactoryRestorePointRsp_from_obj

TRecoverFactoryRestorePointRsp.proto_property = {'TaskId'}

TRecoverFactoryRestorePointRsp.default = {0}

TRecoverFactoryRestorePointRsp.struct = {{name = 'TaskId', is_array = false, struct = nil}}

function TRecoverFactoryRestorePointRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TaskId', self.TaskId, 'uint32', false, errs)

    if self.TaskId ~= nil then
    end

    TRecoverFactoryRestorePointRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRecoverFactoryRestorePointRsp.proto_property, errs)
    return self
end

function TRecoverFactoryRestorePointRsp:unpack(_)
    return self.TaskId
end

msg.RecoverFactoryRestorePointRsp = TRecoverFactoryRestorePointRsp

---@class Configurations.RecoverFactoryRestorePointReq
local TRecoverFactoryRestorePointReq = {}
TRecoverFactoryRestorePointReq.__index = TRecoverFactoryRestorePointReq
TRecoverFactoryRestorePointReq.group = {}

local function TRecoverFactoryRestorePointReq_from_obj(obj)
    return setmetatable(obj, TRecoverFactoryRestorePointReq)
end

function TRecoverFactoryRestorePointReq.new()
    return TRecoverFactoryRestorePointReq_from_obj({})
end
---@param obj Configurations.RecoverFactoryRestorePointReq
function TRecoverFactoryRestorePointReq:init_from_obj(obj)

end

function TRecoverFactoryRestorePointReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRecoverFactoryRestorePointReq.group)
end

TRecoverFactoryRestorePointReq.from_obj = TRecoverFactoryRestorePointReq_from_obj

TRecoverFactoryRestorePointReq.proto_property = {}

TRecoverFactoryRestorePointReq.default = {}

TRecoverFactoryRestorePointReq.struct = {}

function TRecoverFactoryRestorePointReq:validate(prefix, errs)
    prefix = prefix or ''

    TRecoverFactoryRestorePointReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRecoverFactoryRestorePointReq.proto_property, errs)
    return self
end

function TRecoverFactoryRestorePointReq:unpack(_)
end

msg.RecoverFactoryRestorePointReq = TRecoverFactoryRestorePointReq

---@class Configurations.CustomizationBackupRsp
---@field TaskId integer
local TCustomizationBackupRsp = {}
TCustomizationBackupRsp.__index = TCustomizationBackupRsp
TCustomizationBackupRsp.group = {}

local function TCustomizationBackupRsp_from_obj(obj)
    return setmetatable(obj, TCustomizationBackupRsp)
end

function TCustomizationBackupRsp.new(TaskId)
    return TCustomizationBackupRsp_from_obj({TaskId = TaskId})
end
---@param obj Configurations.CustomizationBackupRsp
function TCustomizationBackupRsp:init_from_obj(obj)
    self.TaskId = obj.TaskId
end

function TCustomizationBackupRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCustomizationBackupRsp.group)
end

TCustomizationBackupRsp.from_obj = TCustomizationBackupRsp_from_obj

TCustomizationBackupRsp.proto_property = {'TaskId'}

TCustomizationBackupRsp.default = {0}

TCustomizationBackupRsp.struct = {{name = 'TaskId', is_array = false, struct = nil}}

function TCustomizationBackupRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TaskId', self.TaskId, 'uint32', false, errs)

    if self.TaskId ~= nil then
    end

    TCustomizationBackupRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCustomizationBackupRsp.proto_property, errs)
    return self
end

function TCustomizationBackupRsp:unpack(_)
    return self.TaskId
end

msg.CustomizationBackupRsp = TCustomizationBackupRsp

---@class Configurations.CustomizationBackupReq
local TCustomizationBackupReq = {}
TCustomizationBackupReq.__index = TCustomizationBackupReq
TCustomizationBackupReq.group = {}

local function TCustomizationBackupReq_from_obj(obj)
    return setmetatable(obj, TCustomizationBackupReq)
end

function TCustomizationBackupReq.new()
    return TCustomizationBackupReq_from_obj({})
end
---@param obj Configurations.CustomizationBackupReq
function TCustomizationBackupReq:init_from_obj(obj)

end

function TCustomizationBackupReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCustomizationBackupReq.group)
end

TCustomizationBackupReq.from_obj = TCustomizationBackupReq_from_obj

TCustomizationBackupReq.proto_property = {}

TCustomizationBackupReq.default = {}

TCustomizationBackupReq.struct = {}

function TCustomizationBackupReq:validate(prefix, errs)
    prefix = prefix or ''

    TCustomizationBackupReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCustomizationBackupReq.proto_property, errs)
    return self
end

function TCustomizationBackupReq:unpack(_)
end

msg.CustomizationBackupReq = TCustomizationBackupReq

---@class Configurations.FactoryBackupRsp
---@field TaskId integer
local TFactoryBackupRsp = {}
TFactoryBackupRsp.__index = TFactoryBackupRsp
TFactoryBackupRsp.group = {}

local function TFactoryBackupRsp_from_obj(obj)
    return setmetatable(obj, TFactoryBackupRsp)
end

function TFactoryBackupRsp.new(TaskId)
    return TFactoryBackupRsp_from_obj({TaskId = TaskId})
end
---@param obj Configurations.FactoryBackupRsp
function TFactoryBackupRsp:init_from_obj(obj)
    self.TaskId = obj.TaskId
end

function TFactoryBackupRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFactoryBackupRsp.group)
end

TFactoryBackupRsp.from_obj = TFactoryBackupRsp_from_obj

TFactoryBackupRsp.proto_property = {'TaskId'}

TFactoryBackupRsp.default = {0}

TFactoryBackupRsp.struct = {{name = 'TaskId', is_array = false, struct = nil}}

function TFactoryBackupRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TaskId', self.TaskId, 'uint32', false, errs)

    if self.TaskId ~= nil then
    end

    TFactoryBackupRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFactoryBackupRsp.proto_property, errs)
    return self
end

function TFactoryBackupRsp:unpack(_)
    return self.TaskId
end

msg.FactoryBackupRsp = TFactoryBackupRsp

---@class Configurations.FactoryBackupReq
local TFactoryBackupReq = {}
TFactoryBackupReq.__index = TFactoryBackupReq
TFactoryBackupReq.group = {}

local function TFactoryBackupReq_from_obj(obj)
    return setmetatable(obj, TFactoryBackupReq)
end

function TFactoryBackupReq.new()
    return TFactoryBackupReq_from_obj({})
end
---@param obj Configurations.FactoryBackupReq
function TFactoryBackupReq:init_from_obj(obj)

end

function TFactoryBackupReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFactoryBackupReq.group)
end

TFactoryBackupReq.from_obj = TFactoryBackupReq_from_obj

TFactoryBackupReq.proto_property = {}

TFactoryBackupReq.default = {}

TFactoryBackupReq.struct = {}

function TFactoryBackupReq:validate(prefix, errs)
    prefix = prefix or ''

    TFactoryBackupReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFactoryBackupReq.proto_property, errs)
    return self
end

function TFactoryBackupReq:unpack(_)
end

msg.FactoryBackupReq = TFactoryBackupReq

local Configurations = {}

local Mdb = require 'mc.mdb'

---@class Configurations: Table
Configurations.Configurations = Mdb.register_interface('bmc.kepler.Managers.Configurations', {}, {
    FactoryBackup = {'a{ss}', 'u', msg.FactoryBackupReq, msg.FactoryBackupRsp},
    CustomizationBackup = {'a{ss}', 'u', msg.CustomizationBackupReq, msg.CustomizationBackupRsp},
    RecoverFactoryRestorePoint = {
        'a{ss}', 'u', msg.RecoverFactoryRestorePointReq, msg.RecoverFactoryRestorePointRsp
    },
    RecoverCustomRestorePoint = {
        'a{ss}', 'u', msg.RecoverCustomRestorePointReq, msg.RecoverCustomRestorePointRsp
    }
}, {})
return Configurations
