-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local MCAdminInterface = require 'mdb.bmc.kepler.MCAdminInterface'
local SystemControlInterface = require 'mdb.bmc.kepler.SystemControlInterface'
local DftInterface = require 'mdb.bmc.kepler.DftInterface'

local childs = {}
local MacaService = {childs = childs}

local Mdb = require 'mc.mdb'

local TMacaService = Mdb.register_object('/bmc/kepler/MacaService', {
    {name = 'MCAdmin', interface = MCAdminInterface.MCAdmin},
    {name = 'SystemControl', interface = SystemControlInterface.SystemControl},
    {name = 'Dft', interface = DftInterface.Dft}
})
MacaService.MacaService = TMacaService

function TMacaService:ctor()
    self.path = '/bmc/kepler/MacaService'
end

return MacaService
