-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class MCAdmin.GetComponentListRsp
---@field OutData string[]
local TGetComponentListRsp = {}
TGetComponentListRsp.__index = TGetComponentListRsp
TGetComponentListRsp.group = {}

local function TGetComponentListRsp_from_obj(obj)
    return setmetatable(obj, TGetComponentListRsp)
end

function TGetComponentListRsp.new(OutData)
    return TGetComponentListRsp_from_obj({OutData = OutData})
end
---@param obj MCAdmin.GetComponentListRsp
function TGetComponentListRsp:init_from_obj(obj)
    self.OutData = obj.OutData
end

function TGetComponentListRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetComponentListRsp.group)
end

TGetComponentListRsp.from_obj = TGetComponentListRsp_from_obj

TGetComponentListRsp.proto_property = {'OutData'}

TGetComponentListRsp.default = {{}}

TGetComponentListRsp.struct = {{name = 'OutData', is_array = true, struct = nil}}

function TGetComponentListRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.RequiredArray(prefix .. 'OutData', self.OutData, 'string', false, errs)

    TGetComponentListRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetComponentListRsp.proto_property, errs)
    return self
end

function TGetComponentListRsp:unpack(_)
    return self.OutData
end

msg.GetComponentListRsp = TGetComponentListRsp

---@class MCAdmin.GetComponentListReq
local TGetComponentListReq = {}
TGetComponentListReq.__index = TGetComponentListReq
TGetComponentListReq.group = {}

local function TGetComponentListReq_from_obj(obj)
    return setmetatable(obj, TGetComponentListReq)
end

function TGetComponentListReq.new()
    return TGetComponentListReq_from_obj({})
end
---@param obj MCAdmin.GetComponentListReq
function TGetComponentListReq:init_from_obj(obj)

end

function TGetComponentListReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetComponentListReq.group)
end

TGetComponentListReq.from_obj = TGetComponentListReq_from_obj

TGetComponentListReq.proto_property = {}

TGetComponentListReq.default = {}

TGetComponentListReq.struct = {}

function TGetComponentListReq:validate(prefix, errs)
    prefix = prefix or ''

    TGetComponentListReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetComponentListReq.proto_property, errs)
    return self
end

function TGetComponentListReq:unpack(_)
end

msg.GetComponentListReq = TGetComponentListReq

local MCAdmin = {}

local Mdb = require 'mc.mdb'

---@class MCAdmin: Table
MCAdmin.MCAdmin = Mdb.register_interface('bmc.kepler.MCAdmin', {}, {
    GetComponentList = {'a{ss}', 'as', msg.GetComponentListReq, msg.GetComponentListRsp}
}, {})
return MCAdmin
