-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class KeyService.CiphertextUpdatedRsp
local TCiphertextUpdatedRsp = {}
TCiphertextUpdatedRsp.__index = TCiphertextUpdatedRsp
TCiphertextUpdatedRsp.group = {}

local function TCiphertextUpdatedRsp_from_obj(obj)
    return setmetatable(obj, TCiphertextUpdatedRsp)
end

function TCiphertextUpdatedRsp.new()
    return TCiphertextUpdatedRsp_from_obj({})
end
---@param obj KeyService.CiphertextUpdatedRsp
function TCiphertextUpdatedRsp:init_from_obj(obj)

end

function TCiphertextUpdatedRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCiphertextUpdatedRsp.group)
end

TCiphertextUpdatedRsp.from_obj = TCiphertextUpdatedRsp_from_obj

TCiphertextUpdatedRsp.proto_property = {}

TCiphertextUpdatedRsp.default = {}

TCiphertextUpdatedRsp.struct = {}

function TCiphertextUpdatedRsp:validate(prefix, errs)
    prefix = prefix or ''

    TCiphertextUpdatedRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCiphertextUpdatedRsp.proto_property, errs)
    return self
end

function TCiphertextUpdatedRsp:unpack(_)
end

msg.CiphertextUpdatedRsp = TCiphertextUpdatedRsp

---@class KeyService.CiphertextUpdatedReq
---@field DomainId integer
---@field KeyId integer
local TCiphertextUpdatedReq = {}
TCiphertextUpdatedReq.__index = TCiphertextUpdatedReq
TCiphertextUpdatedReq.group = {}

local function TCiphertextUpdatedReq_from_obj(obj)
    return setmetatable(obj, TCiphertextUpdatedReq)
end

function TCiphertextUpdatedReq.new(DomainId, KeyId)
    return TCiphertextUpdatedReq_from_obj({DomainId = DomainId, KeyId = KeyId})
end
---@param obj KeyService.CiphertextUpdatedReq
function TCiphertextUpdatedReq:init_from_obj(obj)
    self.DomainId = obj.DomainId
    self.KeyId = obj.KeyId
end

function TCiphertextUpdatedReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCiphertextUpdatedReq.group)
end

TCiphertextUpdatedReq.from_obj = TCiphertextUpdatedReq_from_obj

TCiphertextUpdatedReq.proto_property = {'DomainId', 'KeyId'}

TCiphertextUpdatedReq.default = {0, 0}

TCiphertextUpdatedReq.struct = {
    {name = 'DomainId', is_array = false, struct = nil},
    {name = 'KeyId', is_array = false, struct = nil}
}

function TCiphertextUpdatedReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'DomainId', self.DomainId, 'uint32', false, errs)
    validate.Required(prefix .. 'KeyId', self.KeyId, 'uint32', false, errs)

    TCiphertextUpdatedReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCiphertextUpdatedReq.proto_property, errs)
    return self
end

function TCiphertextUpdatedReq:unpack(_)
    return self.DomainId, self.KeyId
end

msg.CiphertextUpdatedReq = TCiphertextUpdatedReq

---@class KeyService.UpdateKeyRsp
local TUpdateKeyRsp = {}
TUpdateKeyRsp.__index = TUpdateKeyRsp
TUpdateKeyRsp.group = {}

local function TUpdateKeyRsp_from_obj(obj)
    return setmetatable(obj, TUpdateKeyRsp)
end

function TUpdateKeyRsp.new()
    return TUpdateKeyRsp_from_obj({})
end
---@param obj KeyService.UpdateKeyRsp
function TUpdateKeyRsp:init_from_obj(obj)

end

function TUpdateKeyRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpdateKeyRsp.group)
end

TUpdateKeyRsp.from_obj = TUpdateKeyRsp_from_obj

TUpdateKeyRsp.proto_property = {}

TUpdateKeyRsp.default = {}

TUpdateKeyRsp.struct = {}

function TUpdateKeyRsp:validate(prefix, errs)
    prefix = prefix or ''

    TUpdateKeyRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpdateKeyRsp.proto_property, errs)
    return self
end

function TUpdateKeyRsp:unpack(_)
end

msg.UpdateKeyRsp = TUpdateKeyRsp

---@class KeyService.UpdateKeyReq
local TUpdateKeyReq = {}
TUpdateKeyReq.__index = TUpdateKeyReq
TUpdateKeyReq.group = {}

local function TUpdateKeyReq_from_obj(obj)
    return setmetatable(obj, TUpdateKeyReq)
end

function TUpdateKeyReq.new()
    return TUpdateKeyReq_from_obj({})
end
---@param obj KeyService.UpdateKeyReq
function TUpdateKeyReq:init_from_obj(obj)

end

function TUpdateKeyReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpdateKeyReq.group)
end

TUpdateKeyReq.from_obj = TUpdateKeyReq_from_obj

TUpdateKeyReq.proto_property = {}

TUpdateKeyReq.default = {}

TUpdateKeyReq.struct = {}

function TUpdateKeyReq:validate(prefix, errs)
    prefix = prefix or ''

    TUpdateKeyReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpdateKeyReq.proto_property, errs)
    return self
end

function TUpdateKeyReq:unpack(_)
end

msg.UpdateKeyReq = TUpdateKeyReq

local KeyService = {}

local Mdb = require 'mc.mdb'

---@class KeyService: Table
---@field UpdateInterval integer
---@field LastUpdateTime integer
KeyService.KeyService = Mdb.register_interface('bmc.kepler.KeyService', {
    UpdateInterval = {'u', nil, false, 0},
    LastUpdateTime = {'u', nil, true, 0}
}, {
    UpdateKey = {'a{ss}', '', msg.UpdateKeyReq, msg.UpdateKeyRsp},
    CiphertextUpdated = {'a{ss}uu', '', msg.CiphertextUpdatedReq, msg.CiphertextUpdatedRsp}
}, {})
return KeyService
