-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class MasterKeys.CiphertextUpdatedRsp
local TCiphertextUpdatedRsp = {}
TCiphertextUpdatedRsp.__index = TCiphertextUpdatedRsp
TCiphertextUpdatedRsp.group = {}

local function TCiphertextUpdatedRsp_from_obj(obj)
    return setmetatable(obj, TCiphertextUpdatedRsp)
end

function TCiphertextUpdatedRsp.new()
    return TCiphertextUpdatedRsp_from_obj({})
end
---@param obj MasterKeys.CiphertextUpdatedRsp
function TCiphertextUpdatedRsp:init_from_obj(obj)

end

function TCiphertextUpdatedRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCiphertextUpdatedRsp.group)
end

TCiphertextUpdatedRsp.from_obj = TCiphertextUpdatedRsp_from_obj

TCiphertextUpdatedRsp.proto_property = {}

TCiphertextUpdatedRsp.default = {}

TCiphertextUpdatedRsp.struct = {}

function TCiphertextUpdatedRsp:validate(prefix, errs)
    prefix = prefix or ''

    TCiphertextUpdatedRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCiphertextUpdatedRsp.proto_property, errs)
    return self
end

function TCiphertextUpdatedRsp:unpack(_)
end

msg.CiphertextUpdatedRsp = TCiphertextUpdatedRsp

---@class MasterKeys.CiphertextUpdatedReq
---@field DomainId integer
---@field KeyId integer
local TCiphertextUpdatedReq = {}
TCiphertextUpdatedReq.__index = TCiphertextUpdatedReq
TCiphertextUpdatedReq.group = {}

local function TCiphertextUpdatedReq_from_obj(obj)
    return setmetatable(obj, TCiphertextUpdatedReq)
end

function TCiphertextUpdatedReq.new(DomainId, KeyId)
    return TCiphertextUpdatedReq_from_obj({DomainId = DomainId, KeyId = KeyId})
end
---@param obj MasterKeys.CiphertextUpdatedReq
function TCiphertextUpdatedReq:init_from_obj(obj)
    self.DomainId = obj.DomainId
    self.KeyId = obj.KeyId
end

function TCiphertextUpdatedReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCiphertextUpdatedReq.group)
end

TCiphertextUpdatedReq.from_obj = TCiphertextUpdatedReq_from_obj

TCiphertextUpdatedReq.proto_property = {'DomainId', 'KeyId'}

TCiphertextUpdatedReq.default = {0, 0}

TCiphertextUpdatedReq.struct = {
    {name = 'DomainId', is_array = false, struct = nil},
    {name = 'KeyId', is_array = false, struct = nil}
}

function TCiphertextUpdatedReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'DomainId', self.DomainId, 'uint32', false, errs)
    validate.Required(prefix .. 'KeyId', self.KeyId, 'uint32', false, errs)

    TCiphertextUpdatedReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCiphertextUpdatedReq.proto_property, errs)
    return self
end

function TCiphertextUpdatedReq:unpack(_)
    return self.DomainId, self.KeyId
end

msg.CiphertextUpdatedReq = TCiphertextUpdatedReq

---@class MasterKeys.UpdateMasterKeyRsp
---@field Ret integer
local TUpdateMasterKeyRsp = {}
TUpdateMasterKeyRsp.__index = TUpdateMasterKeyRsp
TUpdateMasterKeyRsp.group = {}

local function TUpdateMasterKeyRsp_from_obj(obj)
    return setmetatable(obj, TUpdateMasterKeyRsp)
end

function TUpdateMasterKeyRsp.new(Ret)
    return TUpdateMasterKeyRsp_from_obj({Ret = Ret})
end
---@param obj MasterKeys.UpdateMasterKeyRsp
function TUpdateMasterKeyRsp:init_from_obj(obj)
    self.Ret = obj.Ret
end

function TUpdateMasterKeyRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpdateMasterKeyRsp.group)
end

TUpdateMasterKeyRsp.from_obj = TUpdateMasterKeyRsp_from_obj

TUpdateMasterKeyRsp.proto_property = {'Ret'}

TUpdateMasterKeyRsp.default = {0}

TUpdateMasterKeyRsp.struct = {{name = 'Ret', is_array = false, struct = nil}}

function TUpdateMasterKeyRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Ret', self.Ret, 'uint32', false, errs)

    TUpdateMasterKeyRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpdateMasterKeyRsp.proto_property, errs)
    return self
end

function TUpdateMasterKeyRsp:unpack(_)
    return self.Ret
end

msg.UpdateMasterKeyRsp = TUpdateMasterKeyRsp

---@class MasterKeys.UpdateMasterKeyReq
local TUpdateMasterKeyReq = {}
TUpdateMasterKeyReq.__index = TUpdateMasterKeyReq
TUpdateMasterKeyReq.group = {}

local function TUpdateMasterKeyReq_from_obj(obj)
    return setmetatable(obj, TUpdateMasterKeyReq)
end

function TUpdateMasterKeyReq.new()
    return TUpdateMasterKeyReq_from_obj({})
end
---@param obj MasterKeys.UpdateMasterKeyReq
function TUpdateMasterKeyReq:init_from_obj(obj)

end

function TUpdateMasterKeyReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpdateMasterKeyReq.group)
end

TUpdateMasterKeyReq.from_obj = TUpdateMasterKeyReq_from_obj

TUpdateMasterKeyReq.proto_property = {}

TUpdateMasterKeyReq.default = {}

TUpdateMasterKeyReq.struct = {}

function TUpdateMasterKeyReq:validate(prefix, errs)
    prefix = prefix or ''

    TUpdateMasterKeyReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpdateMasterKeyReq.proto_property, errs)
    return self
end

function TUpdateMasterKeyReq:unpack(_)
end

msg.UpdateMasterKeyReq = TUpdateMasterKeyReq

---@class MasterKeys.RegistNewMasterKeyRsp
---@field DomainId integer
local TRegistNewMasterKeyRsp = {}
TRegistNewMasterKeyRsp.__index = TRegistNewMasterKeyRsp
TRegistNewMasterKeyRsp.group = {}

local function TRegistNewMasterKeyRsp_from_obj(obj)
    return setmetatable(obj, TRegistNewMasterKeyRsp)
end

function TRegistNewMasterKeyRsp.new(DomainId)
    return TRegistNewMasterKeyRsp_from_obj({DomainId = DomainId})
end
---@param obj MasterKeys.RegistNewMasterKeyRsp
function TRegistNewMasterKeyRsp:init_from_obj(obj)
    self.DomainId = obj.DomainId
end

function TRegistNewMasterKeyRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRegistNewMasterKeyRsp.group)
end

TRegistNewMasterKeyRsp.from_obj = TRegistNewMasterKeyRsp_from_obj

TRegistNewMasterKeyRsp.proto_property = {'DomainId'}

TRegistNewMasterKeyRsp.default = {0}

TRegistNewMasterKeyRsp.struct = {{name = 'DomainId', is_array = false, struct = nil}}

function TRegistNewMasterKeyRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'DomainId', self.DomainId, 'uint32', false, errs)

    TRegistNewMasterKeyRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRegistNewMasterKeyRsp.proto_property, errs)
    return self
end

function TRegistNewMasterKeyRsp:unpack(_)
    return self.DomainId
end

msg.RegistNewMasterKeyRsp = TRegistNewMasterKeyRsp

---@class MasterKeys.RegistNewMasterKeyReq
---@field AppName string
---@field KsfName string
---@field KsfBakName string
---@field KsfPath string
---@field KsfBakPath string
---@field OwnerId integer
---@field GroupId integer
local TRegistNewMasterKeyReq = {}
TRegistNewMasterKeyReq.__index = TRegistNewMasterKeyReq
TRegistNewMasterKeyReq.group = {}

local function TRegistNewMasterKeyReq_from_obj(obj)
    return setmetatable(obj, TRegistNewMasterKeyReq)
end

function TRegistNewMasterKeyReq.new(AppName, KsfName, KsfBakName, KsfPath, KsfBakPath, OwnerId,
    GroupId)
    return TRegistNewMasterKeyReq_from_obj({
        AppName = AppName,
        KsfName = KsfName,
        KsfBakName = KsfBakName,
        KsfPath = KsfPath,
        KsfBakPath = KsfBakPath,
        OwnerId = OwnerId,
        GroupId = GroupId
    })
end
---@param obj MasterKeys.RegistNewMasterKeyReq
function TRegistNewMasterKeyReq:init_from_obj(obj)
    self.AppName = obj.AppName
    self.KsfName = obj.KsfName
    self.KsfBakName = obj.KsfBakName
    self.KsfPath = obj.KsfPath
    self.KsfBakPath = obj.KsfBakPath
    self.OwnerId = obj.OwnerId
    self.GroupId = obj.GroupId
end

function TRegistNewMasterKeyReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRegistNewMasterKeyReq.group)
end

TRegistNewMasterKeyReq.from_obj = TRegistNewMasterKeyReq_from_obj

TRegistNewMasterKeyReq.proto_property = {
    'AppName', 'KsfName', 'KsfBakName', 'KsfPath', 'KsfBakPath', 'OwnerId', 'GroupId'
}

TRegistNewMasterKeyReq.default = {'', '', '', '', '', 0, 0}

TRegistNewMasterKeyReq.struct = {
    {name = 'AppName', is_array = false, struct = nil},
    {name = 'KsfName', is_array = false, struct = nil},
    {name = 'KsfBakName', is_array = false, struct = nil},
    {name = 'KsfPath', is_array = false, struct = nil},
    {name = 'KsfBakPath', is_array = false, struct = nil},
    {name = 'OwnerId', is_array = false, struct = nil},
    {name = 'GroupId', is_array = false, struct = nil}
}

function TRegistNewMasterKeyReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'AppName', self.AppName, 'string', false, errs)
    validate.Required(prefix .. 'KsfName', self.KsfName, 'string', false, errs)
    validate.Required(prefix .. 'KsfBakName', self.KsfBakName, 'string', false, errs)
    validate.Required(prefix .. 'KsfPath', self.KsfPath, 'string', false, errs)
    validate.Required(prefix .. 'KsfBakPath', self.KsfBakPath, 'string', false, errs)
    validate.Required(prefix .. 'OwnerId', self.OwnerId, 'uint32', false, errs)
    validate.Required(prefix .. 'GroupId', self.GroupId, 'uint32', false, errs)

    TRegistNewMasterKeyReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRegistNewMasterKeyReq.proto_property, errs)
    return self
end

function TRegistNewMasterKeyReq:unpack(_)
    return self.AppName, self.KsfName, self.KsfBakName, self.KsfPath, self.KsfBakPath, self.OwnerId,
        self.GroupId
end

msg.RegistNewMasterKeyReq = TRegistNewMasterKeyReq

local MasterKeys = {}

local Mdb = require 'mc.mdb'

---@class MasterKeys: Table
---@field UpdateInterval integer
---@field LastUpdateTime integer
MasterKeys.MasterKeys = Mdb.register_interface('bmc.kepler.KeyService.MasterKeys', {
    UpdateInterval = {'u', nil, false, nil},
    LastUpdateTime = {'u', nil, true, nil}
}, {
    RegistNewMasterKey = {
        'sssssuu', 'u', false, msg.RegistNewMasterKeyReq, msg.RegistNewMasterKeyRsp
    },
    UpdateMasterKey = {'', 'u', false, msg.UpdateMasterKeyReq, msg.UpdateMasterKeyRsp},
    CiphertextUpdated = {'uu', '', false, msg.CiphertextUpdatedReq, msg.CiphertextUpdatedRsp}
}, {})
return MasterKeys
