-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class Keys.RegisterKeyRsp
---@field DomainId integer
local TRegisterKeyRsp = {}
TRegisterKeyRsp.__index = TRegisterKeyRsp
TRegisterKeyRsp.group = {}

local function TRegisterKeyRsp_from_obj(obj)
    return setmetatable(obj, TRegisterKeyRsp)
end

function TRegisterKeyRsp.new(DomainId)
    return TRegisterKeyRsp_from_obj({DomainId = DomainId})
end
---@param obj Keys.RegisterKeyRsp
function TRegisterKeyRsp:init_from_obj(obj)
    self.DomainId = obj.DomainId
end

function TRegisterKeyRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRegisterKeyRsp.group)
end

TRegisterKeyRsp.from_obj = TRegisterKeyRsp_from_obj

TRegisterKeyRsp.proto_property = {'DomainId'}

TRegisterKeyRsp.default = {0}

TRegisterKeyRsp.struct = {{name = 'DomainId', is_array = false, struct = nil}}

function TRegisterKeyRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'DomainId', self.DomainId, 'uint32', false, errs)

    TRegisterKeyRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRegisterKeyRsp.proto_property, errs)
    return self
end

function TRegisterKeyRsp:unpack(_)
    return self.DomainId
end

msg.RegisterKeyRsp = TRegisterKeyRsp

---@class Keys.RegisterKeyReq
---@field AppName string
---@field KsfName string
---@field KsfBakName string
---@field KsfPath string
---@field KsfBakPath string
---@field OwnerId integer
---@field GroupId integer
local TRegisterKeyReq = {}
TRegisterKeyReq.__index = TRegisterKeyReq
TRegisterKeyReq.group = {}

local function TRegisterKeyReq_from_obj(obj)
    return setmetatable(obj, TRegisterKeyReq)
end

function TRegisterKeyReq.new(AppName, KsfName, KsfBakName, KsfPath, KsfBakPath, OwnerId, GroupId)
    return TRegisterKeyReq_from_obj({
        AppName = AppName,
        KsfName = KsfName,
        KsfBakName = KsfBakName,
        KsfPath = KsfPath,
        KsfBakPath = KsfBakPath,
        OwnerId = OwnerId,
        GroupId = GroupId
    })
end
---@param obj Keys.RegisterKeyReq
function TRegisterKeyReq:init_from_obj(obj)
    self.AppName = obj.AppName
    self.KsfName = obj.KsfName
    self.KsfBakName = obj.KsfBakName
    self.KsfPath = obj.KsfPath
    self.KsfBakPath = obj.KsfBakPath
    self.OwnerId = obj.OwnerId
    self.GroupId = obj.GroupId
end

function TRegisterKeyReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRegisterKeyReq.group)
end

TRegisterKeyReq.from_obj = TRegisterKeyReq_from_obj

TRegisterKeyReq.proto_property = {
    'AppName', 'KsfName', 'KsfBakName', 'KsfPath', 'KsfBakPath', 'OwnerId', 'GroupId'
}

TRegisterKeyReq.default = {'', '', '', '', '', 0, 0}

TRegisterKeyReq.struct = {
    {name = 'AppName', is_array = false, struct = nil},
    {name = 'KsfName', is_array = false, struct = nil},
    {name = 'KsfBakName', is_array = false, struct = nil},
    {name = 'KsfPath', is_array = false, struct = nil},
    {name = 'KsfBakPath', is_array = false, struct = nil},
    {name = 'OwnerId', is_array = false, struct = nil},
    {name = 'GroupId', is_array = false, struct = nil}
}

function TRegisterKeyReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'AppName', self.AppName, 'string', false, errs)
    validate.Required(prefix .. 'KsfName', self.KsfName, 'string', false, errs)
    validate.Required(prefix .. 'KsfBakName', self.KsfBakName, 'string', false, errs)
    validate.Required(prefix .. 'KsfPath', self.KsfPath, 'string', false, errs)
    validate.Required(prefix .. 'KsfBakPath', self.KsfBakPath, 'string', false, errs)
    validate.Required(prefix .. 'OwnerId', self.OwnerId, 'uint32', false, errs)
    validate.Required(prefix .. 'GroupId', self.GroupId, 'uint32', false, errs)

    TRegisterKeyReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRegisterKeyReq.proto_property, errs)
    return self
end

function TRegisterKeyReq:unpack(_)
    return self.AppName, self.KsfName, self.KsfBakName, self.KsfPath, self.KsfBakPath, self.OwnerId,
        self.GroupId
end

msg.RegisterKeyReq = TRegisterKeyReq

local Keys = {}

local Mdb = require 'mc.mdb'

---@class Keys: Table
Keys.Keys = Mdb.register_interface('bmc.kepler.KeyService.Keys', {}, {
    RegisterKey = {'a{ss}sssssuu', 'u', msg.RegisterKeyReq, msg.RegisterKeyRsp}
}, {})
return Keys
