-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local Key = {}

local Mdb = require 'mc.mdb'

---@class Key: Table
---@field DomainId integer
---@field KeyId integer
---@field KeyType integer
---@field Status integer
---@field GenerateType integer
---@field CreateTime integer
---@field ExpiredTime integer
---@field CiphertextKeyId integer
Key.Key = Mdb.register_interface('bmc.kepler.KeyService.Key', {
    DomainId = {'u', nil, true, nil},
    KeyId = {'u', nil, true, nil},
    KeyType = {'u', nil, true, nil},
    Status = {'u', nil, true, nil},
    GenerateType = {'u', nil, true, nil},
    CreateTime = {'u', nil, true, nil},
    ExpiredTime = {'u', nil, true, nil},
    CiphertextKeyId = {'u', nil, true, 4294967295}
}, {}, {})
return Key
