-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local HwproxyMsg = {}

---@class HwproxyMsg.BlockReadReq
---@field Offset integer
---@field Length integer
local TBlockReadReq = {}
TBlockReadReq.__index = TBlockReadReq
TBlockReadReq.group = {}

local function TBlockReadReq_from_obj(obj)
    return setmetatable(obj, TBlockReadReq)
end

function TBlockReadReq.new(Offset, Length)
    return TBlockReadReq_from_obj({Offset = Offset, Length = Length})
end
---@param obj HwproxyMsg.BlockReadReq
function TBlockReadReq:init_from_obj(obj)
    self.Offset = obj.Offset
    self.Length = obj.Length
end

function TBlockReadReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBlockReadReq.group)
end

TBlockReadReq.from_obj = TBlockReadReq_from_obj

TBlockReadReq.proto_property = {'Offset', 'Length'}

TBlockReadReq.default = {0, 0}

TBlockReadReq.struct = {
    {name = 'Offset', is_array = false, struct = nil},
    {name = 'Length', is_array = false, struct = nil}
}

function TBlockReadReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Offset', self.Offset, 'uint32', false, errs)
    validate.Required(prefix .. 'Length', self.Length, 'uint32', false, errs)

    TBlockReadReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBlockReadReq.proto_property, errs)
    return self
end

function TBlockReadReq:unpack(_)
    return self.Offset, self.Length
end

HwproxyMsg.BlockReadReq = TBlockReadReq

---@class HwproxyMsg.BlockReadRsp
---@field OutData integer[]
local TBlockReadRsp = {}
TBlockReadRsp.__index = TBlockReadRsp
TBlockReadRsp.group = {}

local function TBlockReadRsp_from_obj(obj)
    return setmetatable(obj, TBlockReadRsp)
end

function TBlockReadRsp.new(OutData)
    return TBlockReadRsp_from_obj({OutData = OutData})
end
---@param obj HwproxyMsg.BlockReadRsp
function TBlockReadRsp:init_from_obj(obj)
    self.OutData = obj.OutData
end

function TBlockReadRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBlockReadRsp.group)
end

TBlockReadRsp.from_obj = TBlockReadRsp_from_obj

TBlockReadRsp.proto_property = {'OutData'}

TBlockReadRsp.default = {{}}

TBlockReadRsp.struct = {{name = 'OutData', is_array = true, struct = nil}}

function TBlockReadRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.RequiredArray(prefix .. 'OutData', self.OutData, 'uint8', false, errs)

    TBlockReadRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBlockReadRsp.proto_property, errs)
    return self
end

function TBlockReadRsp:unpack(_)
    return self.OutData
end

HwproxyMsg.BlockReadRsp = TBlockReadRsp

---@class HwproxyMsg.BlockWriteReq
---@field Offset integer
---@field InData integer[]
local TBlockWriteReq = {}
TBlockWriteReq.__index = TBlockWriteReq
TBlockWriteReq.group = {}

local function TBlockWriteReq_from_obj(obj)
    return setmetatable(obj, TBlockWriteReq)
end

function TBlockWriteReq.new(Offset, InData)
    return TBlockWriteReq_from_obj({Offset = Offset, InData = InData})
end
---@param obj HwproxyMsg.BlockWriteReq
function TBlockWriteReq:init_from_obj(obj)
    self.Offset = obj.Offset
    self.InData = obj.InData
end

function TBlockWriteReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBlockWriteReq.group)
end

TBlockWriteReq.from_obj = TBlockWriteReq_from_obj

TBlockWriteReq.proto_property = {'Offset', 'InData'}

TBlockWriteReq.default = {0, {}}

TBlockWriteReq.struct = {
    {name = 'Offset', is_array = false, struct = nil},
    {name = 'InData', is_array = true, struct = nil}
}

function TBlockWriteReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Offset', self.Offset, 'uint32', false, errs)
    validate.RequiredArray(prefix .. 'InData', self.InData, 'uint8', false, errs)

    TBlockWriteReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBlockWriteReq.proto_property, errs)
    return self
end

function TBlockWriteReq:unpack(_)
    return self.Offset, self.InData
end

HwproxyMsg.BlockWriteReq = TBlockWriteReq

---@class HwproxyMsg.GetChipIdcodeRsp
---@field DeviceId integer[]
local TGetChipIdcodeRsp = {}
TGetChipIdcodeRsp.__index = TGetChipIdcodeRsp
TGetChipIdcodeRsp.group = {}

local function TGetChipIdcodeRsp_from_obj(obj)
    return setmetatable(obj, TGetChipIdcodeRsp)
end

function TGetChipIdcodeRsp.new(DeviceId)
    return TGetChipIdcodeRsp_from_obj({DeviceId = DeviceId})
end
---@param obj HwproxyMsg.GetChipIdcodeRsp
function TGetChipIdcodeRsp:init_from_obj(obj)
    self.DeviceId = obj.DeviceId
end

function TGetChipIdcodeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetChipIdcodeRsp.group)
end

TGetChipIdcodeRsp.from_obj = TGetChipIdcodeRsp_from_obj

TGetChipIdcodeRsp.proto_property = {'DeviceId'}

TGetChipIdcodeRsp.default = {{}}

TGetChipIdcodeRsp.struct = {{name = 'DeviceId', is_array = true, struct = nil}}

function TGetChipIdcodeRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.RequiredArray(prefix .. 'DeviceId', self.DeviceId, 'uint32[]', false, errs)

    TGetChipIdcodeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetChipIdcodeRsp.proto_property, errs)
    return self
end

function TGetChipIdcodeRsp:unpack(_)
    return self.DeviceId
end

HwproxyMsg.GetChipIdcodeRsp = TGetChipIdcodeRsp

---@class HwproxyMsg.SetTargetNumberReq
---@field Number integer
local TSetTargetNumberReq = {}
TSetTargetNumberReq.__index = TSetTargetNumberReq
TSetTargetNumberReq.group = {}

local function TSetTargetNumberReq_from_obj(obj)
    return setmetatable(obj, TSetTargetNumberReq)
end

function TSetTargetNumberReq.new(Number)
    return TSetTargetNumberReq_from_obj({Number = Number})
end
---@param obj HwproxyMsg.SetTargetNumberReq
function TSetTargetNumberReq:init_from_obj(obj)
    self.Number = obj.Number
end

function TSetTargetNumberReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetTargetNumberReq.group)
end

TSetTargetNumberReq.from_obj = TSetTargetNumberReq_from_obj

TSetTargetNumberReq.proto_property = {'Number'}

TSetTargetNumberReq.default = {0}

TSetTargetNumberReq.struct = {{name = 'Number', is_array = false, struct = nil}}

function TSetTargetNumberReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Number', self.Number, 'uint32', false, errs)

    TSetTargetNumberReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetTargetNumberReq.proto_property, errs)
    return self
end

function TSetTargetNumberReq:unpack(_)
    return self.Number
end

HwproxyMsg.SetTargetNumberReq = TSetTargetNumberReq

---@class HwproxyMsg.SetBypassModeReq
---@field Enable boolean
local TSetBypassModeReq = {}
TSetBypassModeReq.__index = TSetBypassModeReq
TSetBypassModeReq.group = {}

local function TSetBypassModeReq_from_obj(obj)
    return setmetatable(obj, TSetBypassModeReq)
end

function TSetBypassModeReq.new(Enable)
    return TSetBypassModeReq_from_obj({Enable = Enable})
end
---@param obj HwproxyMsg.SetBypassModeReq
function TSetBypassModeReq:init_from_obj(obj)
    self.Enable = obj.Enable
end

function TSetBypassModeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBypassModeReq.group)
end

TSetBypassModeReq.from_obj = TSetBypassModeReq_from_obj

TSetBypassModeReq.proto_property = {'Enable'}

TSetBypassModeReq.default = {false}

TSetBypassModeReq.struct = {{name = 'Enable', is_array = false, struct = nil}}

function TSetBypassModeReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Enable', self.Enable, 'bool', false, errs)

    TSetBypassModeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBypassModeReq.proto_property, errs)
    return self
end

function TSetBypassModeReq:unpack(_)
    return self.Enable
end

HwproxyMsg.SetBypassModeReq = TSetBypassModeReq

return HwproxyMsg
