-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class InterfaceFoo.MethodFooRsp
---@field Result integer
local TMethodFooRsp = {}
TMethodFooRsp.__index = TMethodFooRsp
TMethodFooRsp.group = {}

local function TMethodFooRsp_from_obj(obj)
    return setmetatable(obj, TMethodFooRsp)
end

function TMethodFooRsp.new(Result)
    return TMethodFooRsp_from_obj({Result = Result})
end
---@param obj InterfaceFoo.MethodFooRsp
function TMethodFooRsp:init_from_obj(obj)
    self.Result = obj.Result
end

function TMethodFooRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMethodFooRsp.group)
end

TMethodFooRsp.from_obj = TMethodFooRsp_from_obj

TMethodFooRsp.proto_property = {'Result'}

TMethodFooRsp.default = {0}

TMethodFooRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TMethodFooRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Result', self.Result, 'uint32', false, errs)

    TMethodFooRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMethodFooRsp.proto_property, errs)
    return self
end

function TMethodFooRsp:unpack(_)
    return self.Result
end

msg.MethodFooRsp = TMethodFooRsp

---@class InterfaceFoo.MethodFooReq
---@field Arg1 integer
local TMethodFooReq = {}
TMethodFooReq.__index = TMethodFooReq
TMethodFooReq.group = {}

local function TMethodFooReq_from_obj(obj)
    return setmetatable(obj, TMethodFooReq)
end

function TMethodFooReq.new(Arg1)
    return TMethodFooReq_from_obj({Arg1 = Arg1})
end
---@param obj InterfaceFoo.MethodFooReq
function TMethodFooReq:init_from_obj(obj)
    self.Arg1 = obj.Arg1
end

function TMethodFooReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMethodFooReq.group)
end

TMethodFooReq.from_obj = TMethodFooReq_from_obj

TMethodFooReq.proto_property = {'Arg1'}

TMethodFooReq.default = {0}

TMethodFooReq.struct = {{name = 'Arg1', is_array = false, struct = nil}}

function TMethodFooReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Arg1', self.Arg1, 'uint32', false, errs)

    validate.ranges(prefix .. 'Arg1', self.Arg1, 1, 50, errs)

    TMethodFooReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMethodFooReq.proto_property, errs)
    return self
end

function TMethodFooReq:unpack(_)
    return self.Arg1
end

msg.MethodFooReq = TMethodFooReq

local InterfaceFoo = {}

local Mdb = require 'mc.mdb'

---@class InterfaceFoo: Table
---@field Name string
---@field Status integer
InterfaceFoo.InterfaceFoo = Mdb.register_interface('bmc.kepler.Example.InterfaceFoo', {
    Name = {'s', nil, false, nil},
    Status = {'u', nil, true, nil}
}, {MethodFoo = {'a{ss}u', 'u', msg.MethodFooReq, msg.MethodFooRsp}}, {})
return InterfaceFoo
