-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class Dft.MockLogStormRsp
local TMockLogStormRsp = {}
TMockLogStormRsp.__index = TMockLogStormRsp
TMockLogStormRsp.group = {}

local function TMockLogStormRsp_from_obj(obj)
    return setmetatable(obj, TMockLogStormRsp)
end

function TMockLogStormRsp.new()
    return TMockLogStormRsp_from_obj({})
end
---@param obj Dft.MockLogStormRsp
function TMockLogStormRsp:init_from_obj(obj)

end

function TMockLogStormRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMockLogStormRsp.group)
end

TMockLogStormRsp.from_obj = TMockLogStormRsp_from_obj

TMockLogStormRsp.proto_property = {}

TMockLogStormRsp.default = {}

TMockLogStormRsp.struct = {}

function TMockLogStormRsp:validate(prefix, errs)
    prefix = prefix or ''

    TMockLogStormRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMockLogStormRsp.proto_property, errs)
    return self
end

function TMockLogStormRsp:unpack(_)
end

msg.MockLogStormRsp = TMockLogStormRsp

---@class Dft.MockLogStormReq
---@field Count integer
local TMockLogStormReq = {}
TMockLogStormReq.__index = TMockLogStormReq
TMockLogStormReq.group = {}

local function TMockLogStormReq_from_obj(obj)
    return setmetatable(obj, TMockLogStormReq)
end

function TMockLogStormReq.new(Count)
    return TMockLogStormReq_from_obj({Count = Count})
end
---@param obj Dft.MockLogStormReq
function TMockLogStormReq:init_from_obj(obj)
    self.Count = obj.Count
end

function TMockLogStormReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMockLogStormReq.group)
end

TMockLogStormReq.from_obj = TMockLogStormReq_from_obj

TMockLogStormReq.proto_property = {'Count'}

TMockLogStormReq.default = {0}

TMockLogStormReq.struct = {{name = 'Count', is_array = false, struct = nil}}

function TMockLogStormReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Count', self.Count, 'uint32', false, errs)

    TMockLogStormReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMockLogStormReq.proto_property, errs)
    return self
end

function TMockLogStormReq:unpack(_)
    return self.Count
end

msg.MockLogStormReq = TMockLogStormReq

local Dft = {}

local Mdb = require 'mc.mdb'

---@class Dft: Table
Dft.Dft = Mdb.register_interface('bmc.kepler.Dft', {}, {
    MockLogStorm = {'a{ss}u', '', msg.MockLogStormReq, msg.MockLogStormRsp}
}, {})
return Dft
