-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local Connector = {}

local Mdb = require 'mc.mdb'

---@class Connector: Table
---@field Bom string
---@field Slot integer
---@field Position integer
---@field Presence integer
---@field Id string
---@field AuxId string
---@field Buses string[]
---@field SystemId integer
---@field SilkText string
---@field TargetType integer
Connector.Connector = Mdb.register_interface('bmc.kepler.Connector', {
    Bom = {'s', nil, true, nil},
    Slot = {'y', nil, true, nil},
    Position = {'t', nil, true, nil},
    Presence = {'y', nil, false, nil},
    Id = {'s', nil, false, nil},
    AuxId = {'s', nil, false, nil},
    Buses = {'as', nil, true, nil},
    SystemId = {'y', nil, true, nil},
    SilkText = {'s', nil, true, nil},
    TargetType = {'y', nil, true, nil}
}, {}, {})
return Connector
