-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local ChipInterface = require 'mdb.bmc.kepler.ChipInterface'
local BlockIOInterface = require 'mdb.bmc.kepler.Chip.BlockIOInterface'
local BitIOInterface = require 'mdb.bmc.kepler.Chip.BitIOInterface'

local childs = {}
local Smc = {childs = childs}

local Mdb = require 'mc.mdb'

local TSmc = Mdb.register_object('/bmc/kepler/Chip/Smc/:Id', {
    {name = 'Chip', interface = ChipInterface.Chip},
    {name = 'BlockIO', interface = BlockIOInterface.BlockIO},
    {name = 'BitIO', interface = BitIOInterface.BitIO}
})
Smc.Smc = TSmc

function TSmc:ctor(Id)
    self.path = '/bmc/kepler/Chip/Smc/' .. Id .. ''
end

return Smc
