-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class JtagTarget.SetBypassModeReq
---@field Enable boolean
local TSetBypassModeReq = {}
TSetBypassModeReq.__index = TSetBypassModeReq
TSetBypassModeReq.group = {}

local function TSetBypassModeReq_from_obj(obj)
    return setmetatable(obj, TSetBypassModeReq)
end

function TSetBypassModeReq.new(Enable)
    return TSetBypassModeReq_from_obj({Enable = Enable})
end
---@param obj JtagTarget.SetBypassModeReq
function TSetBypassModeReq:init_from_obj(obj)
    self.Enable = obj.Enable
end

function TSetBypassModeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBypassModeReq.group)
end

TSetBypassModeReq.from_obj = TSetBypassModeReq_from_obj

TSetBypassModeReq.proto_property = {'Enable'}

TSetBypassModeReq.default = {false}

TSetBypassModeReq.struct = {{name = 'Enable', is_array = false, struct = nil}}

function TSetBypassModeReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Enable', self.Enable, 'bool', false, errs)

    TSetBypassModeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBypassModeReq.proto_property, errs)
    return self
end

function TSetBypassModeReq:unpack(_)
    return self.Enable
end

msg.SetBypassModeReq = TSetBypassModeReq

---@class JtagTarget.SetTargetNumberReq
---@field Num integer
local TSetTargetNumberReq = {}
TSetTargetNumberReq.__index = TSetTargetNumberReq
TSetTargetNumberReq.group = {}

local function TSetTargetNumberReq_from_obj(obj)
    return setmetatable(obj, TSetTargetNumberReq)
end

function TSetTargetNumberReq.new(Num)
    return TSetTargetNumberReq_from_obj({Num = Num})
end
---@param obj JtagTarget.SetTargetNumberReq
function TSetTargetNumberReq:init_from_obj(obj)
    self.Num = obj.Num
end

function TSetTargetNumberReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetTargetNumberReq.group)
end

TSetTargetNumberReq.from_obj = TSetTargetNumberReq_from_obj

TSetTargetNumberReq.proto_property = {'Num'}

TSetTargetNumberReq.default = {0}

TSetTargetNumberReq.struct = {{name = 'Num', is_array = false, struct = nil}}

function TSetTargetNumberReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Num', self.Num, 'uint32', false, errs)

    TSetTargetNumberReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetTargetNumberReq.proto_property, errs)
    return self
end

function TSetTargetNumberReq:unpack(_)
    return self.Num
end

msg.SetTargetNumberReq = TSetTargetNumberReq

---@class JtagTarget.GetChipIdcodeRsp
---@field DeviceId integer[]
local TGetChipIdcodeRsp = {}
TGetChipIdcodeRsp.__index = TGetChipIdcodeRsp
TGetChipIdcodeRsp.group = {}

local function TGetChipIdcodeRsp_from_obj(obj)
    return setmetatable(obj, TGetChipIdcodeRsp)
end

function TGetChipIdcodeRsp.new(DeviceId)
    return TGetChipIdcodeRsp_from_obj({DeviceId = DeviceId})
end
---@param obj JtagTarget.GetChipIdcodeRsp
function TGetChipIdcodeRsp:init_from_obj(obj)
    self.DeviceId = obj.DeviceId
end

function TGetChipIdcodeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetChipIdcodeRsp.group)
end

TGetChipIdcodeRsp.from_obj = TGetChipIdcodeRsp_from_obj

TGetChipIdcodeRsp.proto_property = {'DeviceId'}

TGetChipIdcodeRsp.default = {{}}

TGetChipIdcodeRsp.struct = {{name = 'DeviceId', is_array = true, struct = nil}}

function TGetChipIdcodeRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.RequiredArray(prefix .. 'DeviceId', self.DeviceId, 'uint32', false, errs)

    TGetChipIdcodeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetChipIdcodeRsp.proto_property, errs)
    return self
end

function TGetChipIdcodeRsp:unpack(_)
    return self.DeviceId
end

msg.GetChipIdcodeRsp = TGetChipIdcodeRsp

local JtagTarget = {}

local Mdb = require 'mc.mdb'

---@class JtagTarget: Table
JtagTarget.JtagTarget = Mdb.register_interface('bmc.kepler.Chip.JtagTarget', {}, {
    GetChipIdcode = {'a{ss}', 'au', nil, msg.GetChipIdcodeRsp},
    SetTargetNumber = {'a{ss}u', '', msg.SetTargetNumberReq, nil},
    SetBypassMode = {'a{ss}b', '', msg.SetBypassModeReq, nil}
}, {})
return JtagTarget
