-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class BlockIO.WriteReadRsp
---@field OutData integer[]
local TWriteReadRsp = {}
TWriteReadRsp.__index = TWriteReadRsp
TWriteReadRsp.group = {}

local function TWriteReadRsp_from_obj(obj)
    return setmetatable(obj, TWriteReadRsp)
end

function TWriteReadRsp.new(OutData)
    return TWriteReadRsp_from_obj({OutData = OutData})
end
---@param obj BlockIO.WriteReadRsp
function TWriteReadRsp:init_from_obj(obj)
    self.OutData = obj.OutData
end

function TWriteReadRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TWriteReadRsp.group)
end

TWriteReadRsp.from_obj = TWriteReadRsp_from_obj

TWriteReadRsp.proto_property = {'OutData'}

TWriteReadRsp.default = {{}}

TWriteReadRsp.struct = {{name = 'OutData', is_array = true, struct = nil}}

function TWriteReadRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.RequiredArray(prefix .. 'OutData', self.OutData, 'uint8', false, errs)

    TWriteReadRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TWriteReadRsp.proto_property, errs)
    return self
end

function TWriteReadRsp:unpack(_)
    return self.OutData
end

msg.WriteReadRsp = TWriteReadRsp

---@class BlockIO.WriteReadReq
---@field InData integer[]
---@field ReadLength integer
local TWriteReadReq = {}
TWriteReadReq.__index = TWriteReadReq
TWriteReadReq.group = {}

local function TWriteReadReq_from_obj(obj)
    return setmetatable(obj, TWriteReadReq)
end

function TWriteReadReq.new(InData, ReadLength)
    return TWriteReadReq_from_obj({InData = InData, ReadLength = ReadLength})
end
---@param obj BlockIO.WriteReadReq
function TWriteReadReq:init_from_obj(obj)
    self.InData = obj.InData
    self.ReadLength = obj.ReadLength
end

function TWriteReadReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TWriteReadReq.group)
end

TWriteReadReq.from_obj = TWriteReadReq_from_obj

TWriteReadReq.proto_property = {'InData', 'ReadLength'}

TWriteReadReq.default = {{}, 0}

TWriteReadReq.struct = {
    {name = 'InData', is_array = true, struct = nil},
    {name = 'ReadLength', is_array = false, struct = nil}
}

function TWriteReadReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.RequiredArray(prefix .. 'InData', self.InData, 'uint8', false, errs)
    validate.Required(prefix .. 'ReadLength', self.ReadLength, 'uint32', false, errs)

    TWriteReadReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TWriteReadReq.proto_property, errs)
    return self
end

function TWriteReadReq:unpack(_)
    return self.InData, self.ReadLength
end

msg.WriteReadReq = TWriteReadReq

---@class BlockIO.WriteReq
---@field Offset integer
---@field InData integer[]
local TWriteReq = {}
TWriteReq.__index = TWriteReq
TWriteReq.group = {}

local function TWriteReq_from_obj(obj)
    return setmetatable(obj, TWriteReq)
end

function TWriteReq.new(Offset, InData)
    return TWriteReq_from_obj({Offset = Offset, InData = InData})
end
---@param obj BlockIO.WriteReq
function TWriteReq:init_from_obj(obj)
    self.Offset = obj.Offset
    self.InData = obj.InData
end

function TWriteReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TWriteReq.group)
end

TWriteReq.from_obj = TWriteReq_from_obj

TWriteReq.proto_property = {'Offset', 'InData'}

TWriteReq.default = {0, {}}

TWriteReq.struct = {
    {name = 'Offset', is_array = false, struct = nil},
    {name = 'InData', is_array = true, struct = nil}
}

function TWriteReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Offset', self.Offset, 'uint32', false, errs)
    validate.RequiredArray(prefix .. 'InData', self.InData, 'uint8', false, errs)

    TWriteReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TWriteReq.proto_property, errs)
    return self
end

function TWriteReq:unpack(_)
    return self.Offset, self.InData
end

msg.WriteReq = TWriteReq

---@class BlockIO.ReadRsp
---@field OutData integer[]
local TReadRsp = {}
TReadRsp.__index = TReadRsp
TReadRsp.group = {}

local function TReadRsp_from_obj(obj)
    return setmetatable(obj, TReadRsp)
end

function TReadRsp.new(OutData)
    return TReadRsp_from_obj({OutData = OutData})
end
---@param obj BlockIO.ReadRsp
function TReadRsp:init_from_obj(obj)
    self.OutData = obj.OutData
end

function TReadRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TReadRsp.group)
end

TReadRsp.from_obj = TReadRsp_from_obj

TReadRsp.proto_property = {'OutData'}

TReadRsp.default = {{}}

TReadRsp.struct = {{name = 'OutData', is_array = true, struct = nil}}

function TReadRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.RequiredArray(prefix .. 'OutData', self.OutData, 'uint8', false, errs)

    TReadRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TReadRsp.proto_property, errs)
    return self
end

function TReadRsp:unpack(_)
    return self.OutData
end

msg.ReadRsp = TReadRsp

---@class BlockIO.ReadReq
---@field Offset integer
---@field Length integer
local TReadReq = {}
TReadReq.__index = TReadReq
TReadReq.group = {}

local function TReadReq_from_obj(obj)
    return setmetatable(obj, TReadReq)
end

function TReadReq.new(Offset, Length)
    return TReadReq_from_obj({Offset = Offset, Length = Length})
end
---@param obj BlockIO.ReadReq
function TReadReq:init_from_obj(obj)
    self.Offset = obj.Offset
    self.Length = obj.Length
end

function TReadReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TReadReq.group)
end

TReadReq.from_obj = TReadReq_from_obj

TReadReq.proto_property = {'Offset', 'Length'}

TReadReq.default = {0, 0}

TReadReq.struct = {
    {name = 'Offset', is_array = false, struct = nil},
    {name = 'Length', is_array = false, struct = nil}
}

function TReadReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Offset', self.Offset, 'uint32', false, errs)
    validate.Required(prefix .. 'Length', self.Length, 'uint32', false, errs)

    TReadReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TReadReq.proto_property, errs)
    return self
end

function TReadReq:unpack(_)
    return self.Offset, self.Length
end

msg.ReadReq = TReadReq

local BlockIO = {}

local Mdb = require 'mc.mdb'

---@class BlockIO: Table
BlockIO.BlockIO = Mdb.register_interface('bmc.kepler.Chip.BlockIO', {}, {
    Read = {'a{ss}uu', 'ay', msg.ReadReq, msg.ReadRsp},
    Write = {'a{ss}uay', '', msg.WriteReq, nil},
    WriteRead = {'a{ss}ayu', 'ay', msg.WriteReadReq, msg.WriteReadRsp}
}, {})
return BlockIO
