-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'
local create_enum_type = require 'mc.enum'

local msg = {}
local defs = {}

---@class defs.CertificateUsageType: Enum
local ECertificateUsageType = create_enum_type('CertificateUsageType')
ECertificateUsageType.default = ECertificateUsageType.new(2147483647)
ECertificateUsageType.struct = nil
ECertificateUsageType.ManagerCACertificate = ECertificateUsageType.new(0)
ECertificateUsageType.ManagerSSLCertificate = ECertificateUsageType.new(1)
ECertificateUsageType.ManagerAccountCertificate = ECertificateUsageType.new(2)

defs.CertificateUsageType = ECertificateUsageType

---@class Certificate.DeleteCRLRsp
local TDeleteCRLRsp = {}
TDeleteCRLRsp.__index = TDeleteCRLRsp
TDeleteCRLRsp.group = {}

local function TDeleteCRLRsp_from_obj(obj)
    return setmetatable(obj, TDeleteCRLRsp)
end

function TDeleteCRLRsp.new()
    return TDeleteCRLRsp_from_obj({})
end
---@param obj Certificate.DeleteCRLRsp
function TDeleteCRLRsp:init_from_obj(obj)

end

function TDeleteCRLRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeleteCRLRsp.group)
end

TDeleteCRLRsp.from_obj = TDeleteCRLRsp_from_obj

TDeleteCRLRsp.proto_property = {}

TDeleteCRLRsp.default = {}

TDeleteCRLRsp.struct = {}

function TDeleteCRLRsp:validate(prefix, errs)
    prefix = prefix or ''

    TDeleteCRLRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeleteCRLRsp.proto_property, errs)
    return self
end

function TDeleteCRLRsp:unpack(_)
end

msg.DeleteCRLRsp = TDeleteCRLRsp

---@class Certificate.DeleteCRLReq
local TDeleteCRLReq = {}
TDeleteCRLReq.__index = TDeleteCRLReq
TDeleteCRLReq.group = {}

local function TDeleteCRLReq_from_obj(obj)
    return setmetatable(obj, TDeleteCRLReq)
end

function TDeleteCRLReq.new()
    return TDeleteCRLReq_from_obj({})
end
---@param obj Certificate.DeleteCRLReq
function TDeleteCRLReq:init_from_obj(obj)

end

function TDeleteCRLReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeleteCRLReq.group)
end

TDeleteCRLReq.from_obj = TDeleteCRLReq_from_obj

TDeleteCRLReq.proto_property = {}

TDeleteCRLReq.default = {}

TDeleteCRLReq.struct = {}

function TDeleteCRLReq:validate(prefix, errs)
    prefix = prefix or ''

    TDeleteCRLReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeleteCRLReq.proto_property, errs)
    return self
end

function TDeleteCRLReq:unpack(_)
end

msg.DeleteCRLReq = TDeleteCRLReq

---@class Certificate.ImportCRLRsp
local TImportCRLRsp = {}
TImportCRLRsp.__index = TImportCRLRsp
TImportCRLRsp.group = {}

local function TImportCRLRsp_from_obj(obj)
    return setmetatable(obj, TImportCRLRsp)
end

function TImportCRLRsp.new()
    return TImportCRLRsp_from_obj({})
end
---@param obj Certificate.ImportCRLRsp
function TImportCRLRsp:init_from_obj(obj)

end

function TImportCRLRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TImportCRLRsp.group)
end

TImportCRLRsp.from_obj = TImportCRLRsp_from_obj

TImportCRLRsp.proto_property = {}

TImportCRLRsp.default = {}

TImportCRLRsp.struct = {}

function TImportCRLRsp:validate(prefix, errs)
    prefix = prefix or ''

    TImportCRLRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TImportCRLRsp.proto_property, errs)
    return self
end

function TImportCRLRsp:unpack(_)
end

msg.ImportCRLRsp = TImportCRLRsp

---@class Certificate.ImportCRLReq
---@field FilePath string
local TImportCRLReq = {}
TImportCRLReq.__index = TImportCRLReq
TImportCRLReq.group = {}

local function TImportCRLReq_from_obj(obj)
    return setmetatable(obj, TImportCRLReq)
end

function TImportCRLReq.new(FilePath)
    return TImportCRLReq_from_obj({FilePath = FilePath})
end
---@param obj Certificate.ImportCRLReq
function TImportCRLReq:init_from_obj(obj)
    self.FilePath = obj.FilePath
end

function TImportCRLReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TImportCRLReq.group)
end

TImportCRLReq.from_obj = TImportCRLReq_from_obj

TImportCRLReq.proto_property = {'FilePath'}

TImportCRLReq.default = {''}

TImportCRLReq.struct = {{name = 'FilePath', is_array = false, struct = nil}}

function TImportCRLReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'FilePath', self.FilePath, 'string', false, errs)

    validate.lens(prefix .. 'FilePath', self.FilePath, 1, 2048, errs)

    TImportCRLReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TImportCRLReq.proto_property, errs)
    return self
end

function TImportCRLReq:unpack(_)
    return self.FilePath
end

msg.ImportCRLReq = TImportCRLReq

local Certificate = {}

local Mdb = require 'mc.mdb'

---@class Certificate: Table
---@field CertificateType integer
---@field CertificateUsageType integer
---@field Fingerprint string
---@field FingerprintHashAlgorithm string
---@field Issuer string
---@field KeyUsage integer[]
---@field SerialNumber string
---@field SignatureAlgorithm string
---@field Subject string
---@field ValidNotAfter string
---@field ValidNotBefore string
---@field FilePath string
---@field CommonName string
---@field CRLStartTime string
---@field CRLExpireTime string
---@field CertCount integer
---@field KeyLength integer
---@field OverDueStatus integer
Certificate.Certificate = Mdb.register_interface('bmc.kepler.CertificateService.Certificate', {
    CertificateType = {'u', nil, true, nil},
    CertificateUsageType = {'u', nil, true, nil},
    Fingerprint = {'s', nil, true, nil},
    FingerprintHashAlgorithm = {'s', nil, true, nil},
    Issuer = {'s', nil, true, nil},
    KeyUsage = {'au', nil, true, nil},
    SerialNumber = {'s', nil, true, nil},
    SignatureAlgorithm = {'s', nil, true, nil},
    Subject = {'s', nil, true, nil},
    ValidNotAfter = {'s', nil, true, nil},
    ValidNotBefore = {'s', nil, true, nil},
    FilePath = {'s', nil, true, nil},
    CommonName = {'s', nil, true, nil},
    CRLStartTime = {'s', nil, true, nil},
    CRLExpireTime = {'s', nil, true, nil},
    CertCount = {'u', nil, true, nil},
    KeyLength = {'u', nil, true, nil},
    OverDueStatus = {'y', nil, true, nil}
}, {
    ImportCRL = {'a{ss}s', '', msg.ImportCRLReq, msg.ImportCRLRsp},
    DeleteCRL = {'a{ss}', '', msg.DeleteCRLReq, msg.DeleteCRLRsp}
}, {})
return Certificate
