-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class AccountService.SetEmergencyLoginAccountRsp
local TSetEmergencyLoginAccountRsp = {}
TSetEmergencyLoginAccountRsp.__index = TSetEmergencyLoginAccountRsp
TSetEmergencyLoginAccountRsp.group = {}

local function TSetEmergencyLoginAccountRsp_from_obj(obj)
    return setmetatable(obj, TSetEmergencyLoginAccountRsp)
end

function TSetEmergencyLoginAccountRsp.new()
    return TSetEmergencyLoginAccountRsp_from_obj({})
end
---@param obj AccountService.SetEmergencyLoginAccountRsp
function TSetEmergencyLoginAccountRsp:init_from_obj(obj)

end

function TSetEmergencyLoginAccountRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetEmergencyLoginAccountRsp.group)
end

TSetEmergencyLoginAccountRsp.from_obj = TSetEmergencyLoginAccountRsp_from_obj

TSetEmergencyLoginAccountRsp.proto_property = {}

TSetEmergencyLoginAccountRsp.default = {}

TSetEmergencyLoginAccountRsp.struct = {}

function TSetEmergencyLoginAccountRsp:validate(prefix, errs)
    prefix = prefix or ''

    TSetEmergencyLoginAccountRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetEmergencyLoginAccountRsp.proto_property, errs)
    return self
end

function TSetEmergencyLoginAccountRsp:unpack(_)
end

msg.SetEmergencyLoginAccountRsp = TSetEmergencyLoginAccountRsp

---@class AccountService.SetEmergencyLoginAccountReq
---@field UserName string
local TSetEmergencyLoginAccountReq = {}
TSetEmergencyLoginAccountReq.__index = TSetEmergencyLoginAccountReq
TSetEmergencyLoginAccountReq.group = {}

local function TSetEmergencyLoginAccountReq_from_obj(obj)
    return setmetatable(obj, TSetEmergencyLoginAccountReq)
end

function TSetEmergencyLoginAccountReq.new(UserName)
    return TSetEmergencyLoginAccountReq_from_obj({UserName = UserName})
end
---@param obj AccountService.SetEmergencyLoginAccountReq
function TSetEmergencyLoginAccountReq:init_from_obj(obj)
    self.UserName = obj.UserName
end

function TSetEmergencyLoginAccountReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetEmergencyLoginAccountReq.group)
end

TSetEmergencyLoginAccountReq.from_obj = TSetEmergencyLoginAccountReq_from_obj

TSetEmergencyLoginAccountReq.proto_property = {'UserName'}

TSetEmergencyLoginAccountReq.default = {''}

TSetEmergencyLoginAccountReq.struct = {{name = 'UserName', is_array = false, struct = nil}}

function TSetEmergencyLoginAccountReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'UserName', self.UserName, 'string', false, errs)

    validate.lens(prefix .. 'UserName', self.UserName, 1, 32, errs)

    TSetEmergencyLoginAccountReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetEmergencyLoginAccountReq.proto_property, errs)
    return self
end

function TSetEmergencyLoginAccountReq:unpack(_)
    return self.UserName
end

msg.SetEmergencyLoginAccountReq = TSetEmergencyLoginAccountReq

---@class AccountService.ExportWeakPasswordDictionaryRsp
local TExportWeakPasswordDictionaryRsp = {}
TExportWeakPasswordDictionaryRsp.__index = TExportWeakPasswordDictionaryRsp
TExportWeakPasswordDictionaryRsp.group = {}

local function TExportWeakPasswordDictionaryRsp_from_obj(obj)
    return setmetatable(obj, TExportWeakPasswordDictionaryRsp)
end

function TExportWeakPasswordDictionaryRsp.new()
    return TExportWeakPasswordDictionaryRsp_from_obj({})
end
---@param obj AccountService.ExportWeakPasswordDictionaryRsp
function TExportWeakPasswordDictionaryRsp:init_from_obj(obj)

end

function TExportWeakPasswordDictionaryRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExportWeakPasswordDictionaryRsp.group)
end

TExportWeakPasswordDictionaryRsp.from_obj = TExportWeakPasswordDictionaryRsp_from_obj

TExportWeakPasswordDictionaryRsp.proto_property = {}

TExportWeakPasswordDictionaryRsp.default = {}

TExportWeakPasswordDictionaryRsp.struct = {}

function TExportWeakPasswordDictionaryRsp:validate(prefix, errs)
    prefix = prefix or ''

    TExportWeakPasswordDictionaryRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TExportWeakPasswordDictionaryRsp.proto_property, errs)
    return self
end

function TExportWeakPasswordDictionaryRsp:unpack(_)
end

msg.ExportWeakPasswordDictionaryRsp = TExportWeakPasswordDictionaryRsp

---@class AccountService.ExportWeakPasswordDictionaryReq
---@field Path string
local TExportWeakPasswordDictionaryReq = {}
TExportWeakPasswordDictionaryReq.__index = TExportWeakPasswordDictionaryReq
TExportWeakPasswordDictionaryReq.group = {}

local function TExportWeakPasswordDictionaryReq_from_obj(obj)
    return setmetatable(obj, TExportWeakPasswordDictionaryReq)
end

function TExportWeakPasswordDictionaryReq.new(Path)
    return TExportWeakPasswordDictionaryReq_from_obj({Path = Path})
end
---@param obj AccountService.ExportWeakPasswordDictionaryReq
function TExportWeakPasswordDictionaryReq:init_from_obj(obj)
    self.Path = obj.Path
end

function TExportWeakPasswordDictionaryReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExportWeakPasswordDictionaryReq.group)
end

TExportWeakPasswordDictionaryReq.from_obj = TExportWeakPasswordDictionaryReq_from_obj

TExportWeakPasswordDictionaryReq.proto_property = {'Path'}

TExportWeakPasswordDictionaryReq.default = {''}

TExportWeakPasswordDictionaryReq.struct = {{name = 'Path', is_array = false, struct = nil}}

function TExportWeakPasswordDictionaryReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Path', self.Path, 'string', false, errs)

    TExportWeakPasswordDictionaryReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TExportWeakPasswordDictionaryReq.proto_property, errs)
    return self
end

function TExportWeakPasswordDictionaryReq:unpack(_)
    return self.Path
end

msg.ExportWeakPasswordDictionaryReq = TExportWeakPasswordDictionaryReq

---@class AccountService.ImportWeakPasswordDictionaryRsp
local TImportWeakPasswordDictionaryRsp = {}
TImportWeakPasswordDictionaryRsp.__index = TImportWeakPasswordDictionaryRsp
TImportWeakPasswordDictionaryRsp.group = {}

local function TImportWeakPasswordDictionaryRsp_from_obj(obj)
    return setmetatable(obj, TImportWeakPasswordDictionaryRsp)
end

function TImportWeakPasswordDictionaryRsp.new()
    return TImportWeakPasswordDictionaryRsp_from_obj({})
end
---@param obj AccountService.ImportWeakPasswordDictionaryRsp
function TImportWeakPasswordDictionaryRsp:init_from_obj(obj)

end

function TImportWeakPasswordDictionaryRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TImportWeakPasswordDictionaryRsp.group)
end

TImportWeakPasswordDictionaryRsp.from_obj = TImportWeakPasswordDictionaryRsp_from_obj

TImportWeakPasswordDictionaryRsp.proto_property = {}

TImportWeakPasswordDictionaryRsp.default = {}

TImportWeakPasswordDictionaryRsp.struct = {}

function TImportWeakPasswordDictionaryRsp:validate(prefix, errs)
    prefix = prefix or ''

    TImportWeakPasswordDictionaryRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TImportWeakPasswordDictionaryRsp.proto_property, errs)
    return self
end

function TImportWeakPasswordDictionaryRsp:unpack(_)
end

msg.ImportWeakPasswordDictionaryRsp = TImportWeakPasswordDictionaryRsp

---@class AccountService.ImportWeakPasswordDictionaryReq
---@field Path string
local TImportWeakPasswordDictionaryReq = {}
TImportWeakPasswordDictionaryReq.__index = TImportWeakPasswordDictionaryReq
TImportWeakPasswordDictionaryReq.group = {}

local function TImportWeakPasswordDictionaryReq_from_obj(obj)
    return setmetatable(obj, TImportWeakPasswordDictionaryReq)
end

function TImportWeakPasswordDictionaryReq.new(Path)
    return TImportWeakPasswordDictionaryReq_from_obj({Path = Path})
end
---@param obj AccountService.ImportWeakPasswordDictionaryReq
function TImportWeakPasswordDictionaryReq:init_from_obj(obj)
    self.Path = obj.Path
end

function TImportWeakPasswordDictionaryReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TImportWeakPasswordDictionaryReq.group)
end

TImportWeakPasswordDictionaryReq.from_obj = TImportWeakPasswordDictionaryReq_from_obj

TImportWeakPasswordDictionaryReq.proto_property = {'Path'}

TImportWeakPasswordDictionaryReq.default = {''}

TImportWeakPasswordDictionaryReq.struct = {{name = 'Path', is_array = false, struct = nil}}

function TImportWeakPasswordDictionaryReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Path', self.Path, 'string', false, errs)

    TImportWeakPasswordDictionaryReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TImportWeakPasswordDictionaryReq.proto_property, errs)
    return self
end

function TImportWeakPasswordDictionaryReq:unpack(_)
    return self.Path
end

msg.ImportWeakPasswordDictionaryReq = TImportWeakPasswordDictionaryReq

local AccountService = {}

local Mdb = require 'mc.mdb'

---@class AccountService: Table
---@field AccountLockoutCounterResetAfter integer
---@field AccountLockoutCounterResetEnabled boolean
---@field AccountLockoutDuration integer
---@field AccountLockoutThreshold integer
---@field AuthFailureLoggingThreshold integer
---@field MaxPasswordLength integer
---@field MinPasswordLength integer
---@field ServiceEnabled boolean
---@field PasswordComplexityEnable boolean
---@field InitialPasswordPromptEnable boolean
---@field MinPasswordValidDays integer
---@field MaxPasswordValidDays integer
---@field EmergencyLoginAccountId integer
---@field InactiveDaysThreshold integer
---@field WeakPasswordDictionaryEnabled boolean
AccountService.AccountService = Mdb.register_interface('bmc.kepler.AccountService', {
    AccountLockoutCounterResetAfter = {'i', nil, false, nil},
    AccountLockoutCounterResetEnabled = {'b', nil, false, nil},
    AccountLockoutDuration = {'i', nil, false, nil},
    AccountLockoutThreshold = {'i', nil, false, nil},
    AuthFailureLoggingThreshold = {'i', nil, false, nil},
    MaxPasswordLength = {'i', nil, true, 20},
    MinPasswordLength = {'i', nil, true, 8},
    ServiceEnabled = {'b', nil, false, nil},
    PasswordComplexityEnable = {'b', nil, false, True},
    InitialPasswordPromptEnable = {'b', nil, false, True},
    MinPasswordValidDays = {'u', nil, false, 0},
    MaxPasswordValidDays = {'u', nil, false, 0},
    EmergencyLoginAccountId = {'y', nil, false, 0},
    InactiveDaysThreshold = {'u', nil, false, 0},
    WeakPasswordDictionaryEnabled = {'b', nil, false, True}
}, {
    ImportWeakPasswordDictionary = {
        'a{ss}s', '', msg.ImportWeakPasswordDictionaryReq, msg.ImportWeakPasswordDictionaryRsp
    },
    ExportWeakPasswordDictionary = {
        'a{ss}s', '', msg.ExportWeakPasswordDictionaryReq, msg.ExportWeakPasswordDictionaryRsp
    },
    SetEmergencyLoginAccount = {
        'a{ss}s', '', msg.SetEmergencyLoginAccountReq, msg.SetEmergencyLoginAccountRsp
    }
}, {})
return AccountService
