-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'
local create_enum_type = require 'mc.enum'

local msg = {}
local defs = {}

---@class defs.PrivilegeType: Enum
local EPrivilegeType = create_enum_type('PrivilegeType')
EPrivilegeType.default = EPrivilegeType.new(2147483647)
EPrivilegeType.struct = nil
EPrivilegeType.UserMgmt = EPrivilegeType.new(0)
EPrivilegeType.BasicSetting = EPrivilegeType.new(1)
EPrivilegeType.KVMMgmt = EPrivilegeType.new(2)
EPrivilegeType.VMMMgmt = EPrivilegeType.new(3)
EPrivilegeType.SecurityMgmt = EPrivilegeType.new(4)
EPrivilegeType.PowerMgmt = EPrivilegeType.new(5)
EPrivilegeType.DiagnoseMgmt = EPrivilegeType.new(6)
EPrivilegeType.ReadOnly = EPrivilegeType.new(7)
EPrivilegeType.ConfigureSelf = EPrivilegeType.new(8)

defs.PrivilegeType = EPrivilegeType

local RestrictedPrivileges = {}

local Mdb = require 'mc.mdb'

---@class RestrictedPrivileges: Table
---@field UserMgmt boolean
---@field BasicSetting boolean
---@field KVMMgmt boolean
---@field VMMMgmt boolean
---@field SecurityMgmt boolean
---@field PowerMgmt boolean
---@field DiagnoseMgmt boolean
---@field ReadOnly boolean
---@field ConfigureSelf boolean
RestrictedPrivileges.RestrictedPrivileges = Mdb.register_interface(
    'bmc.kepler.AccountService.RestrictedPrivileges', {
        UserMgmt = {'b', nil, true, False},
        BasicSetting = {'b', nil, true, False},
        KVMMgmt = {'b', nil, true, False},
        VMMMgmt = {'b', nil, true, False},
        SecurityMgmt = {'b', nil, true, False},
        PowerMgmt = {'b', nil, true, False},
        DiagnoseMgmt = {'b', nil, true, False},
        ReadOnly = {'b', nil, true, False},
        ConfigureSelf = {'b', nil, true, False}
    }, {}, {})
return RestrictedPrivileges
