-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class RemoteGroups.NewRsp
---@field GroupId string
local TNewRsp = {}
TNewRsp.__index = TNewRsp
TNewRsp.group = {}

local function TNewRsp_from_obj(obj)
    return setmetatable(obj, TNewRsp)
end

function TNewRsp.new(GroupId)
    return TNewRsp_from_obj({GroupId = GroupId})
end
---@param obj RemoteGroups.NewRsp
function TNewRsp:init_from_obj(obj)
    self.GroupId = obj.GroupId
end

function TNewRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNewRsp.group)
end

TNewRsp.from_obj = TNewRsp_from_obj

TNewRsp.proto_property = {'GroupId'}

TNewRsp.default = {''}

TNewRsp.struct = {{name = 'GroupId', is_array = false, struct = nil}}

function TNewRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'GroupId', self.GroupId, 'string', false, errs)

    TNewRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNewRsp.proto_property, errs)
    return self
end

function TNewRsp:unpack(_)
    return self.GroupId
end

msg.NewRsp = TNewRsp

---@class RemoteGroups.NewReq
---@field GroupType integer
---@field ControllerId integer
---@field Name string
---@field Folder string
---@field SID string
---@field UserRoleId integer
---@field PermitRuleIds string[]
---@field LoginInterface string[]
local TNewReq = {}
TNewReq.__index = TNewReq
TNewReq.group = {}

local function TNewReq_from_obj(obj)
    return setmetatable(obj, TNewReq)
end

function TNewReq.new(GroupType, ControllerId, Name, Folder, SID, UserRoleId, PermitRuleIds,
    LoginInterface)
    return TNewReq_from_obj({
        GroupType = GroupType,
        ControllerId = ControllerId,
        Name = Name,
        Folder = Folder,
        SID = SID,
        UserRoleId = UserRoleId,
        PermitRuleIds = PermitRuleIds,
        LoginInterface = LoginInterface
    })
end
---@param obj RemoteGroups.NewReq
function TNewReq:init_from_obj(obj)
    self.GroupType = obj.GroupType
    self.ControllerId = obj.ControllerId
    self.Name = obj.Name
    self.Folder = obj.Folder
    self.SID = obj.SID
    self.UserRoleId = obj.UserRoleId
    self.PermitRuleIds = obj.PermitRuleIds
    self.LoginInterface = obj.LoginInterface
end

function TNewReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNewReq.group)
end

TNewReq.from_obj = TNewReq_from_obj

TNewReq.proto_property = {
    'GroupType', 'ControllerId', 'Name', 'Folder', 'SID', 'UserRoleId', 'PermitRuleIds',
    'LoginInterface'
}

TNewReq.default = {0, 0, '', '', '', 0, {}, {}}

TNewReq.struct = {
    {name = 'GroupType', is_array = false, struct = nil},
    {name = 'ControllerId', is_array = false, struct = nil},
    {name = 'Name', is_array = false, struct = nil},
    {name = 'Folder', is_array = false, struct = nil},
    {name = 'SID', is_array = false, struct = nil},
    {name = 'UserRoleId', is_array = false, struct = nil},
    {name = 'PermitRuleIds', is_array = true, struct = nil},
    {name = 'LoginInterface', is_array = true, struct = nil}
}

function TNewReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'GroupType', self.GroupType, 'uint8', true, errs)
    validate.Required(prefix .. 'ControllerId', self.ControllerId, 'uint8', false, errs)
    validate.Required(prefix .. 'Name', self.Name, 'string', false, errs)
    validate.Required(prefix .. 'Folder', self.Folder, 'string', false, errs)
    validate.Required(prefix .. 'SID', self.SID, 'string', false, errs)
    validate.Required(prefix .. 'UserRoleId', self.UserRoleId, 'uint8', false, errs)
    validate.RequiredArray(prefix .. 'PermitRuleIds', self.PermitRuleIds, 'string', false, errs)
    validate.RequiredArray(prefix .. 'LoginInterface', self.LoginInterface, 'string', false, errs)

    TNewReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNewReq.proto_property, errs)
    return self
end

function TNewReq:unpack(_)
    return self.GroupType, self.ControllerId, self.Name, self.Folder, self.SID, self.UserRoleId,
        self.PermitRuleIds, self.LoginInterface
end

msg.NewReq = TNewReq

local RemoteGroups = {}

local Mdb = require 'mc.mdb'

---@class RemoteGroups: Table
RemoteGroups.RemoteGroups = Mdb.register_interface('bmc.kepler.AccountService.RemoteGroups', {}, {
    New = {'a{ss}yysssyasas', 's', msg.NewReq, msg.NewRsp}
}, {})
return RemoteGroups
