-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'
local create_enum_type = require 'mc.enum'

local msg = {}
local defs = {}

---@class defs.SNMPKuType: Enum
local ESNMPKuType = create_enum_type('SNMPKuType')
ESNMPKuType.default = ESNMPKuType.new(2147483647)
ESNMPKuType.struct = nil
ESNMPKuType.Authentication = ESNMPKuType.new(0)
ESNMPKuType.Encryption = ESNMPKuType.new(1)

defs.SNMPKuType = ESNMPKuType

---@class defs.SNMPEncryptionProtocols: Enum
local ESNMPEncryptionProtocols = create_enum_type('SNMPEncryptionProtocols')
ESNMPEncryptionProtocols.default = ESNMPEncryptionProtocols.new(2147483647)
ESNMPEncryptionProtocols.struct = nil
ESNMPEncryptionProtocols.None = ESNMPEncryptionProtocols.new(0)
ESNMPEncryptionProtocols.DES = ESNMPEncryptionProtocols.new(1)
ESNMPEncryptionProtocols.AES128 = ESNMPEncryptionProtocols.new(2)
ESNMPEncryptionProtocols.AES256 = ESNMPEncryptionProtocols.new(3)

defs.SNMPEncryptionProtocols = ESNMPEncryptionProtocols

---@class defs.SNMPAuthenticationProtocols: Enum
local ESNMPAuthenticationProtocols = create_enum_type('SNMPAuthenticationProtocols')
ESNMPAuthenticationProtocols.default = ESNMPAuthenticationProtocols.new(2147483647)
ESNMPAuthenticationProtocols.struct = nil
ESNMPAuthenticationProtocols.None = ESNMPAuthenticationProtocols.new(0)
ESNMPAuthenticationProtocols.MD5 = ESNMPAuthenticationProtocols.new(1)
ESNMPAuthenticationProtocols.SHA96 = ESNMPAuthenticationProtocols.new(2)
ESNMPAuthenticationProtocols.SHA224 = ESNMPAuthenticationProtocols.new(3)
ESNMPAuthenticationProtocols.SHA256 = ESNMPAuthenticationProtocols.new(4)
ESNMPAuthenticationProtocols.SHA384 = ESNMPAuthenticationProtocols.new(5)
ESNMPAuthenticationProtocols.SHA512 = ESNMPAuthenticationProtocols.new(6)

defs.SNMPAuthenticationProtocols = ESNMPAuthenticationProtocols

---@class SnmpUser.SetEncryptionProtocolRsp
local TSetEncryptionProtocolRsp = {}
TSetEncryptionProtocolRsp.__index = TSetEncryptionProtocolRsp
TSetEncryptionProtocolRsp.group = {}

local function TSetEncryptionProtocolRsp_from_obj(obj)
    return setmetatable(obj, TSetEncryptionProtocolRsp)
end

function TSetEncryptionProtocolRsp.new()
    return TSetEncryptionProtocolRsp_from_obj({})
end
---@param obj SnmpUser.SetEncryptionProtocolRsp
function TSetEncryptionProtocolRsp:init_from_obj(obj)

end

function TSetEncryptionProtocolRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetEncryptionProtocolRsp.group)
end

TSetEncryptionProtocolRsp.from_obj = TSetEncryptionProtocolRsp_from_obj

TSetEncryptionProtocolRsp.proto_property = {}

TSetEncryptionProtocolRsp.default = {}

TSetEncryptionProtocolRsp.struct = {}

function TSetEncryptionProtocolRsp:validate(prefix, errs)
    prefix = prefix or ''

    TSetEncryptionProtocolRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetEncryptionProtocolRsp.proto_property, errs)
    return self
end

function TSetEncryptionProtocolRsp:unpack(_)
end

msg.SetEncryptionProtocolRsp = TSetEncryptionProtocolRsp

---@class SnmpUser.SetEncryptionProtocolReq
---@field SNMPEncryptionProtocol integer
local TSetEncryptionProtocolReq = {}
TSetEncryptionProtocolReq.__index = TSetEncryptionProtocolReq
TSetEncryptionProtocolReq.group = {}

local function TSetEncryptionProtocolReq_from_obj(obj)
    return setmetatable(obj, TSetEncryptionProtocolReq)
end

function TSetEncryptionProtocolReq.new(SNMPEncryptionProtocol)
    return TSetEncryptionProtocolReq_from_obj({SNMPEncryptionProtocol = SNMPEncryptionProtocol})
end
---@param obj SnmpUser.SetEncryptionProtocolReq
function TSetEncryptionProtocolReq:init_from_obj(obj)
    self.SNMPEncryptionProtocol = obj.SNMPEncryptionProtocol
end

function TSetEncryptionProtocolReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetEncryptionProtocolReq.group)
end

TSetEncryptionProtocolReq.from_obj = TSetEncryptionProtocolReq_from_obj

TSetEncryptionProtocolReq.proto_property = {'SNMPEncryptionProtocol'}

TSetEncryptionProtocolReq.default = {0}

TSetEncryptionProtocolReq.struct = {
    {name = 'SNMPEncryptionProtocol', is_array = false, struct = nil}
}

function TSetEncryptionProtocolReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'SNMPEncryptionProtocol', self.SNMPEncryptionProtocol, 'uint8',
        false, errs)

    TSetEncryptionProtocolReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetEncryptionProtocolReq.proto_property, errs)
    return self
end

function TSetEncryptionProtocolReq:unpack(_)
    return self.SNMPEncryptionProtocol
end

msg.SetEncryptionProtocolReq = TSetEncryptionProtocolReq

---@class SnmpUser.SetAuthenticationProtocolRsp
local TSetAuthenticationProtocolRsp = {}
TSetAuthenticationProtocolRsp.__index = TSetAuthenticationProtocolRsp
TSetAuthenticationProtocolRsp.group = {}

local function TSetAuthenticationProtocolRsp_from_obj(obj)
    return setmetatable(obj, TSetAuthenticationProtocolRsp)
end

function TSetAuthenticationProtocolRsp.new()
    return TSetAuthenticationProtocolRsp_from_obj({})
end
---@param obj SnmpUser.SetAuthenticationProtocolRsp
function TSetAuthenticationProtocolRsp:init_from_obj(obj)

end

function TSetAuthenticationProtocolRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetAuthenticationProtocolRsp.group)
end

TSetAuthenticationProtocolRsp.from_obj = TSetAuthenticationProtocolRsp_from_obj

TSetAuthenticationProtocolRsp.proto_property = {}

TSetAuthenticationProtocolRsp.default = {}

TSetAuthenticationProtocolRsp.struct = {}

function TSetAuthenticationProtocolRsp:validate(prefix, errs)
    prefix = prefix or ''

    TSetAuthenticationProtocolRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetAuthenticationProtocolRsp.proto_property, errs)
    return self
end

function TSetAuthenticationProtocolRsp:unpack(_)
end

msg.SetAuthenticationProtocolRsp = TSetAuthenticationProtocolRsp

---@class SnmpUser.SetAuthenticationProtocolReq
---@field SNMPAuthenticationProtocol integer
---@field AuthPassword string
---@field EncryPassword string
local TSetAuthenticationProtocolReq = {}
TSetAuthenticationProtocolReq.__index = TSetAuthenticationProtocolReq
TSetAuthenticationProtocolReq.group = {}

local function TSetAuthenticationProtocolReq_from_obj(obj)
    return setmetatable(obj, TSetAuthenticationProtocolReq)
end

function TSetAuthenticationProtocolReq.new(SNMPAuthenticationProtocol, AuthPassword, EncryPassword)
    return TSetAuthenticationProtocolReq_from_obj({
        SNMPAuthenticationProtocol = SNMPAuthenticationProtocol,
        AuthPassword = AuthPassword,
        EncryPassword = EncryPassword
    })
end
---@param obj SnmpUser.SetAuthenticationProtocolReq
function TSetAuthenticationProtocolReq:init_from_obj(obj)
    self.SNMPAuthenticationProtocol = obj.SNMPAuthenticationProtocol
    self.AuthPassword = obj.AuthPassword
    self.EncryPassword = obj.EncryPassword
end

function TSetAuthenticationProtocolReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetAuthenticationProtocolReq.group)
end

TSetAuthenticationProtocolReq.from_obj = TSetAuthenticationProtocolReq_from_obj

TSetAuthenticationProtocolReq.proto_property = {
    'SNMPAuthenticationProtocol', 'AuthPassword', 'EncryPassword'
}

TSetAuthenticationProtocolReq.default = {0, '', ''}

TSetAuthenticationProtocolReq.struct = {
    {name = 'SNMPAuthenticationProtocol', is_array = false, struct = nil},
    {name = 'AuthPassword', is_array = false, struct = nil},
    {name = 'EncryPassword', is_array = false, struct = nil}
}

function TSetAuthenticationProtocolReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'SNMPAuthenticationProtocol', self.SNMPAuthenticationProtocol,
        'uint8', false, errs)
    validate.Required(prefix .. 'AuthPassword', self.AuthPassword, 'string', false, errs)
    validate.Required(prefix .. 'EncryPassword', self.EncryPassword, 'string', false, errs)

    validate.lens(prefix .. 'AuthPassword', self.AuthPassword, 1, 32, errs)
    validate.lens(prefix .. 'EncryPassword', self.EncryPassword, 1, 32, errs)

    TSetAuthenticationProtocolReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetAuthenticationProtocolReq.proto_property, errs)
    return self
end

function TSetAuthenticationProtocolReq:unpack(_)
    return self.SNMPAuthenticationProtocol, self.AuthPassword, self.EncryPassword
end

msg.SetAuthenticationProtocolReq = TSetAuthenticationProtocolReq

local SnmpUser = {}

local Mdb = require 'mc.mdb'

---@class SnmpUser: Table
---@field AuthenticationProtocol integer
---@field EncryptionProtocol integer
---@field AuthenticationKey string
---@field EncryptionKey string
---@field SnmpEncryptionPasswordInitialStatus boolean
---@field AuthenticationProtocolAlarmEnabled boolean
---@field AuthenticationProtocolAlarmContent string
---@field EncryptionProtocolAlarmEnabled boolean
---@field EncryptionProtocolAlarmContent string
SnmpUser.SnmpUser = Mdb.register_interface('bmc.kepler.AccountService.ManagerAccount.SnmpUser', {
    AuthenticationProtocol = {'y', nil, true, nil},
    EncryptionProtocol = {'y', nil, true, nil},
    AuthenticationKey = {'s', nil, true, nil},
    EncryptionKey = {'s', nil, true, nil},
    SnmpEncryptionPasswordInitialStatus = {'b', nil, true, nil},
    AuthenticationProtocolAlarmEnabled = {'b', nil, true, nil},
    AuthenticationProtocolAlarmContent = {'s', nil, true, nil},
    EncryptionProtocolAlarmEnabled = {'b', nil, true, nil},
    EncryptionProtocolAlarmContent = {'s', nil, true, nil}
}, {
    SetAuthenticationProtocol = {
        'a{ss}yss', '', msg.SetAuthenticationProtocolReq, msg.SetAuthenticationProtocolRsp
    },
    SetEncryptionProtocol = {
        'a{ss}y', '', msg.SetEncryptionProtocolReq, msg.SetEncryptionProtocolRsp
    }
}, {})
return SnmpUser
