-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class LDAPController.SetBindDnPasswordRsp
local TSetBindDnPasswordRsp = {}
TSetBindDnPasswordRsp.__index = TSetBindDnPasswordRsp
TSetBindDnPasswordRsp.group = {}

local function TSetBindDnPasswordRsp_from_obj(obj)
    return setmetatable(obj, TSetBindDnPasswordRsp)
end

function TSetBindDnPasswordRsp.new()
    return TSetBindDnPasswordRsp_from_obj({})
end
---@param obj LDAPController.SetBindDnPasswordRsp
function TSetBindDnPasswordRsp:init_from_obj(obj)

end

function TSetBindDnPasswordRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBindDnPasswordRsp.group)
end

TSetBindDnPasswordRsp.from_obj = TSetBindDnPasswordRsp_from_obj

TSetBindDnPasswordRsp.proto_property = {}

TSetBindDnPasswordRsp.default = {}

TSetBindDnPasswordRsp.struct = {}

function TSetBindDnPasswordRsp:validate(prefix, errs)
    prefix = prefix or ''

    TSetBindDnPasswordRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBindDnPasswordRsp.proto_property, errs)
    return self
end

function TSetBindDnPasswordRsp:unpack(_)
end

msg.SetBindDnPasswordRsp = TSetBindDnPasswordRsp

---@class LDAPController.SetBindDnPasswordReq
---@field Password integer[]
local TSetBindDnPasswordReq = {}
TSetBindDnPasswordReq.__index = TSetBindDnPasswordReq
TSetBindDnPasswordReq.group = {}

local function TSetBindDnPasswordReq_from_obj(obj)
    return setmetatable(obj, TSetBindDnPasswordReq)
end

function TSetBindDnPasswordReq.new(Password)
    return TSetBindDnPasswordReq_from_obj({Password = Password})
end
---@param obj LDAPController.SetBindDnPasswordReq
function TSetBindDnPasswordReq:init_from_obj(obj)
    self.Password = obj.Password
end

function TSetBindDnPasswordReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBindDnPasswordReq.group)
end

TSetBindDnPasswordReq.from_obj = TSetBindDnPasswordReq_from_obj

TSetBindDnPasswordReq.proto_property = {'Password'}

TSetBindDnPasswordReq.default = {{}}

TSetBindDnPasswordReq.struct = {{name = 'Password', is_array = true, struct = nil}}

function TSetBindDnPasswordReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.RequiredArray(prefix .. 'Password', self.Password, 'uint8', false, errs)

    validate.lens(prefix .. 'Password', self.Password, 1, 20, errs)

    TSetBindDnPasswordReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBindDnPasswordReq.proto_property, errs)
    return self
end

function TSetBindDnPasswordReq:unpack(_)
    return self.Password
end

msg.SetBindDnPasswordReq = TSetBindDnPasswordReq

local LDAPController = {}

local Mdb = require 'mc.mdb'

---@class LDAPController: Table
---@field Enabled boolean
---@field HostAddr string
---@field Port integer
---@field UserDomain string
---@field Folder string
---@field BindDN string
---@field CertVerifyEnabled boolean
---@field CertVerifyLevel integer
LDAPController.LDAPController = Mdb.register_interface(
    'bmc.kepler.AccountService.LDAP.LDAPController', {
        Enabled = {'b', nil, false, nil},
        HostAddr = {'s', nil, false, nil},
        Port = {'i', nil, false, nil},
        UserDomain = {'s', nil, false, nil},
        Folder = {'s', nil, false, nil},
        BindDN = {'s', nil, false, nil},
        CertVerifyEnabled = {'b', nil, false, nil},
        CertVerifyLevel = {'y', nil, false, nil}
    }, {SetBindDnPassword = {'a{ss}ay', '', msg.SetBindDnPasswordReq, msg.SetBindDnPasswordRsp}}, {})
return LDAPController
