-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local LDAPControllerInterface = require 'mdb.bmc.kepler.AccountService.LDAP.LDAPControllerInterface'

local childs = {}
local LDAPController = {childs = childs}

local Mdb = require 'mc.mdb'

local TLDAPController = Mdb.register_object(
    '/bmc/kepler/AccountService/LDAP/LDAPController/:ControllerId',
    {{name = 'LDAPController', interface = LDAPControllerInterface.LDAPController}})
LDAPController.LDAPController = TLDAPController

function TLDAPController:ctor(ControllerId)
    self.path = '/bmc/kepler/AccountService/LDAP/LDAPController/' .. ControllerId .. ''
end

return LDAPController
