-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class RMCP.GenRmcpAuthCodeRsp
---@field AuthCode integer[]
local TGenRmcpAuthCodeRsp = {}
TGenRmcpAuthCodeRsp.__index = TGenRmcpAuthCodeRsp
TGenRmcpAuthCodeRsp.group = {}

local function TGenRmcpAuthCodeRsp_from_obj(obj)
    return setmetatable(obj, TGenRmcpAuthCodeRsp)
end

function TGenRmcpAuthCodeRsp.new(AuthCode)
    return TGenRmcpAuthCodeRsp_from_obj({AuthCode = AuthCode})
end
---@param obj RMCP.GenRmcpAuthCodeRsp
function TGenRmcpAuthCodeRsp:init_from_obj(obj)
    self.AuthCode = obj.AuthCode
end

function TGenRmcpAuthCodeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGenRmcpAuthCodeRsp.group)
end

TGenRmcpAuthCodeRsp.from_obj = TGenRmcpAuthCodeRsp_from_obj

TGenRmcpAuthCodeRsp.proto_property = {'AuthCode'}

TGenRmcpAuthCodeRsp.default = {{}}

TGenRmcpAuthCodeRsp.struct = {{name = 'AuthCode', is_array = true, struct = nil}}

function TGenRmcpAuthCodeRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.RequiredArray(prefix .. 'AuthCode', self.AuthCode, 'uint8', false, errs)

    TGenRmcpAuthCodeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGenRmcpAuthCodeRsp.proto_property, errs)
    return self
end

function TGenRmcpAuthCodeRsp:unpack(_)
    return self.AuthCode
end

msg.GenRmcpAuthCodeRsp = TGenRmcpAuthCodeRsp

---@class RMCP.GenRmcpAuthCodeReq
---@field AuthAlgo integer
---@field PayLoad integer[]
---@field UserId integer
---@field SessionId integer
---@field SessionSequence integer
---@field Ip string
local TGenRmcpAuthCodeReq = {}
TGenRmcpAuthCodeReq.__index = TGenRmcpAuthCodeReq
TGenRmcpAuthCodeReq.group = {}

local function TGenRmcpAuthCodeReq_from_obj(obj)
    return setmetatable(obj, TGenRmcpAuthCodeReq)
end

function TGenRmcpAuthCodeReq.new(AuthAlgo, PayLoad, UserId, SessionId, SessionSequence, Ip)
    return TGenRmcpAuthCodeReq_from_obj({
        AuthAlgo = AuthAlgo,
        PayLoad = PayLoad,
        UserId = UserId,
        SessionId = SessionId,
        SessionSequence = SessionSequence,
        Ip = Ip
    })
end
---@param obj RMCP.GenRmcpAuthCodeReq
function TGenRmcpAuthCodeReq:init_from_obj(obj)
    self.AuthAlgo = obj.AuthAlgo
    self.PayLoad = obj.PayLoad
    self.UserId = obj.UserId
    self.SessionId = obj.SessionId
    self.SessionSequence = obj.SessionSequence
    self.Ip = obj.Ip
end

function TGenRmcpAuthCodeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGenRmcpAuthCodeReq.group)
end

TGenRmcpAuthCodeReq.from_obj = TGenRmcpAuthCodeReq_from_obj

TGenRmcpAuthCodeReq.proto_property = {
    'AuthAlgo', 'PayLoad', 'UserId', 'SessionId', 'SessionSequence', 'Ip'
}

TGenRmcpAuthCodeReq.default = {0, {}, 0, 0, 0, ''}

TGenRmcpAuthCodeReq.struct = {
    {name = 'AuthAlgo', is_array = false, struct = nil},
    {name = 'PayLoad', is_array = true, struct = nil},
    {name = 'UserId', is_array = false, struct = nil},
    {name = 'SessionId', is_array = false, struct = nil},
    {name = 'SessionSequence', is_array = false, struct = nil},
    {name = 'Ip', is_array = false, struct = nil}
}

function TGenRmcpAuthCodeReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'AuthAlgo', self.AuthAlgo, 'uint8', false, errs)
    validate.RequiredArray(prefix .. 'PayLoad', self.PayLoad, 'uint8', false, errs)
    validate.Required(prefix .. 'UserId', self.UserId, 'uint8', false, errs)
    validate.Required(prefix .. 'SessionId', self.SessionId, 'uint32', false, errs)
    validate.Required(prefix .. 'SessionSequence', self.SessionSequence, 'uint32', false, errs)
    validate.Required(prefix .. 'Ip', self.Ip, 'string', false, errs)

    validate.lens(prefix .. 'PayLoad', self.PayLoad, 1, 255, errs)

    TGenRmcpAuthCodeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGenRmcpAuthCodeReq.proto_property, errs)
    return self
end

function TGenRmcpAuthCodeReq:unpack(_)
    return self.AuthAlgo, self.PayLoad, self.UserId, self.SessionId, self.SessionSequence, self.Ip
end

msg.GenRmcpAuthCodeReq = TGenRmcpAuthCodeReq

---@class RMCP.GenSikRsp
---@field AuthCode integer[]
local TGenSikRsp = {}
TGenSikRsp.__index = TGenSikRsp
TGenSikRsp.group = {}

local function TGenSikRsp_from_obj(obj)
    return setmetatable(obj, TGenSikRsp)
end

function TGenSikRsp.new(AuthCode)
    return TGenSikRsp_from_obj({AuthCode = AuthCode})
end
---@param obj RMCP.GenSikRsp
function TGenSikRsp:init_from_obj(obj)
    self.AuthCode = obj.AuthCode
end

function TGenSikRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGenSikRsp.group)
end

TGenSikRsp.from_obj = TGenSikRsp_from_obj

TGenSikRsp.proto_property = {'AuthCode'}

TGenSikRsp.default = {{}}

TGenSikRsp.struct = {{name = 'AuthCode', is_array = true, struct = nil}}

function TGenSikRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.RequiredArray(prefix .. 'AuthCode', self.AuthCode, 'uint8', false, errs)

    TGenSikRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGenSikRsp.proto_property, errs)
    return self
end

function TGenSikRsp:unpack(_)
    return self.AuthCode
end

msg.GenSikRsp = TGenSikRsp

---@class RMCP.GenSikReq
---@field AuthAlgo integer
---@field UserName string
---@field ConsoleRandom integer[]
---@field ManagedRandom integer[]
---@field Role integer
---@field Ip string
local TGenSikReq = {}
TGenSikReq.__index = TGenSikReq
TGenSikReq.group = {}

local function TGenSikReq_from_obj(obj)
    return setmetatable(obj, TGenSikReq)
end

function TGenSikReq.new(AuthAlgo, UserName, ConsoleRandom, ManagedRandom, Role, Ip)
    return TGenSikReq_from_obj({
        AuthAlgo = AuthAlgo,
        UserName = UserName,
        ConsoleRandom = ConsoleRandom,
        ManagedRandom = ManagedRandom,
        Role = Role,
        Ip = Ip
    })
end
---@param obj RMCP.GenSikReq
function TGenSikReq:init_from_obj(obj)
    self.AuthAlgo = obj.AuthAlgo
    self.UserName = obj.UserName
    self.ConsoleRandom = obj.ConsoleRandom
    self.ManagedRandom = obj.ManagedRandom
    self.Role = obj.Role
    self.Ip = obj.Ip
end

function TGenSikReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGenSikReq.group)
end

TGenSikReq.from_obj = TGenSikReq_from_obj

TGenSikReq.proto_property = {'AuthAlgo', 'UserName', 'ConsoleRandom', 'ManagedRandom', 'Role', 'Ip'}

TGenSikReq.default = {0, '', {}, {}, 0, ''}

TGenSikReq.struct = {
    {name = 'AuthAlgo', is_array = false, struct = nil},
    {name = 'UserName', is_array = false, struct = nil},
    {name = 'ConsoleRandom', is_array = true, struct = nil},
    {name = 'ManagedRandom', is_array = true, struct = nil},
    {name = 'Role', is_array = false, struct = nil}, {name = 'Ip', is_array = false, struct = nil}
}

function TGenSikReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'AuthAlgo', self.AuthAlgo, 'uint8', false, errs)
    validate.Required(prefix .. 'UserName', self.UserName, 'string', false, errs)
    validate.RequiredArray(prefix .. 'ConsoleRandom', self.ConsoleRandom, 'uint8', false, errs)
    validate.RequiredArray(prefix .. 'ManagedRandom', self.ManagedRandom, 'uint8', false, errs)
    validate.Required(prefix .. 'Role', self.Role, 'uint8', false, errs)
    validate.Required(prefix .. 'Ip', self.Ip, 'string', false, errs)

    validate.lens(prefix .. 'UserName', self.UserName, 1, 32, errs)
    validate.lens(prefix .. 'ConsoleRandom', self.ConsoleRandom, 16, 16, errs)
    validate.lens(prefix .. 'ManagedRandom', self.ManagedRandom, 16, 16, errs)

    TGenSikReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGenSikReq.proto_property, errs)
    return self
end

function TGenSikReq:unpack(_)
    return self.AuthAlgo, self.UserName, self.ConsoleRandom, self.ManagedRandom, self.Role, self.Ip
end

msg.GenSikReq = TGenSikReq

---@class RMCP.AuthRakp3Rsp
local TAuthRakp3Rsp = {}
TAuthRakp3Rsp.__index = TAuthRakp3Rsp
TAuthRakp3Rsp.group = {}

local function TAuthRakp3Rsp_from_obj(obj)
    return setmetatable(obj, TAuthRakp3Rsp)
end

function TAuthRakp3Rsp.new()
    return TAuthRakp3Rsp_from_obj({})
end
---@param obj RMCP.AuthRakp3Rsp
function TAuthRakp3Rsp:init_from_obj(obj)

end

function TAuthRakp3Rsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAuthRakp3Rsp.group)
end

TAuthRakp3Rsp.from_obj = TAuthRakp3Rsp_from_obj

TAuthRakp3Rsp.proto_property = {}

TAuthRakp3Rsp.default = {}

TAuthRakp3Rsp.struct = {}

function TAuthRakp3Rsp:validate(prefix, errs)
    prefix = prefix or ''

    TAuthRakp3Rsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAuthRakp3Rsp.proto_property, errs)
    return self
end

function TAuthRakp3Rsp:unpack(_)
end

msg.AuthRakp3Rsp = TAuthRakp3Rsp

---@class RMCP.AuthRakp3Req
---@field AuthAlgo integer
---@field UserName string
---@field ManagedRandom integer[]
---@field ConsoleSid integer
---@field Role integer
---@field AuthCode integer[]
---@field Ip string
local TAuthRakp3Req = {}
TAuthRakp3Req.__index = TAuthRakp3Req
TAuthRakp3Req.group = {}

local function TAuthRakp3Req_from_obj(obj)
    return setmetatable(obj, TAuthRakp3Req)
end

function TAuthRakp3Req.new(AuthAlgo, UserName, ManagedRandom, ConsoleSid, Role, AuthCode, Ip)
    return TAuthRakp3Req_from_obj({
        AuthAlgo = AuthAlgo,
        UserName = UserName,
        ManagedRandom = ManagedRandom,
        ConsoleSid = ConsoleSid,
        Role = Role,
        AuthCode = AuthCode,
        Ip = Ip
    })
end
---@param obj RMCP.AuthRakp3Req
function TAuthRakp3Req:init_from_obj(obj)
    self.AuthAlgo = obj.AuthAlgo
    self.UserName = obj.UserName
    self.ManagedRandom = obj.ManagedRandom
    self.ConsoleSid = obj.ConsoleSid
    self.Role = obj.Role
    self.AuthCode = obj.AuthCode
    self.Ip = obj.Ip
end

function TAuthRakp3Req:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAuthRakp3Req.group)
end

TAuthRakp3Req.from_obj = TAuthRakp3Req_from_obj

TAuthRakp3Req.proto_property = {
    'AuthAlgo', 'UserName', 'ManagedRandom', 'ConsoleSid', 'Role', 'AuthCode', 'Ip'
}

TAuthRakp3Req.default = {0, '', {}, 0, 0, {}, ''}

TAuthRakp3Req.struct = {
    {name = 'AuthAlgo', is_array = false, struct = nil},
    {name = 'UserName', is_array = false, struct = nil},
    {name = 'ManagedRandom', is_array = true, struct = nil},
    {name = 'ConsoleSid', is_array = false, struct = nil},
    {name = 'Role', is_array = false, struct = nil},
    {name = 'AuthCode', is_array = true, struct = nil},
    {name = 'Ip', is_array = false, struct = nil}
}

function TAuthRakp3Req:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'AuthAlgo', self.AuthAlgo, 'uint8', false, errs)
    validate.Required(prefix .. 'UserName', self.UserName, 'string', false, errs)
    validate.RequiredArray(prefix .. 'ManagedRandom', self.ManagedRandom, 'uint8', false, errs)
    validate.Required(prefix .. 'ConsoleSid', self.ConsoleSid, 'uint32', false, errs)
    validate.Required(prefix .. 'Role', self.Role, 'uint8', false, errs)
    validate.RequiredArray(prefix .. 'AuthCode', self.AuthCode, 'uint8', false, errs)
    validate.Required(prefix .. 'Ip', self.Ip, 'string', false, errs)

    validate.lens(prefix .. 'ManagedRandom', self.ManagedRandom, 16, 16, errs)

    TAuthRakp3Req:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAuthRakp3Req.proto_property, errs)
    return self
end

function TAuthRakp3Req:unpack(_)
    return self.AuthAlgo, self.UserName, self.ManagedRandom, self.ConsoleSid, self.Role,
        self.AuthCode, self.Ip
end

msg.AuthRakp3Req = TAuthRakp3Req

---@class RMCP.GenRakp2AuthCodeRsp
---@field AuthCode integer[]
local TGenRakp2AuthCodeRsp = {}
TGenRakp2AuthCodeRsp.__index = TGenRakp2AuthCodeRsp
TGenRakp2AuthCodeRsp.group = {}

local function TGenRakp2AuthCodeRsp_from_obj(obj)
    return setmetatable(obj, TGenRakp2AuthCodeRsp)
end

function TGenRakp2AuthCodeRsp.new(AuthCode)
    return TGenRakp2AuthCodeRsp_from_obj({AuthCode = AuthCode})
end
---@param obj RMCP.GenRakp2AuthCodeRsp
function TGenRakp2AuthCodeRsp:init_from_obj(obj)
    self.AuthCode = obj.AuthCode
end

function TGenRakp2AuthCodeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGenRakp2AuthCodeRsp.group)
end

TGenRakp2AuthCodeRsp.from_obj = TGenRakp2AuthCodeRsp_from_obj

TGenRakp2AuthCodeRsp.proto_property = {'AuthCode'}

TGenRakp2AuthCodeRsp.default = {{}}

TGenRakp2AuthCodeRsp.struct = {{name = 'AuthCode', is_array = true, struct = nil}}

function TGenRakp2AuthCodeRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.RequiredArray(prefix .. 'AuthCode', self.AuthCode, 'uint8', false, errs)

    TGenRakp2AuthCodeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGenRakp2AuthCodeRsp.proto_property, errs)
    return self
end

function TGenRakp2AuthCodeRsp:unpack(_)
    return self.AuthCode
end

msg.GenRakp2AuthCodeRsp = TGenRakp2AuthCodeRsp

---@class RMCP.GenRakp2AuthCodeReq
---@field AuthAlgo integer
---@field UserName string
---@field ConsoleSid integer
---@field ManagedSid integer
---@field ConsoleRandom integer[]
---@field ManagedRandom integer[]
---@field ManagedGuid integer[]
---@field Role integer
---@field Ip string
local TGenRakp2AuthCodeReq = {}
TGenRakp2AuthCodeReq.__index = TGenRakp2AuthCodeReq
TGenRakp2AuthCodeReq.group = {}

local function TGenRakp2AuthCodeReq_from_obj(obj)
    return setmetatable(obj, TGenRakp2AuthCodeReq)
end

function TGenRakp2AuthCodeReq.new(AuthAlgo, UserName, ConsoleSid, ManagedSid, ConsoleRandom,
    ManagedRandom, ManagedGuid, Role, Ip)
    return TGenRakp2AuthCodeReq_from_obj({
        AuthAlgo = AuthAlgo,
        UserName = UserName,
        ConsoleSid = ConsoleSid,
        ManagedSid = ManagedSid,
        ConsoleRandom = ConsoleRandom,
        ManagedRandom = ManagedRandom,
        ManagedGuid = ManagedGuid,
        Role = Role,
        Ip = Ip
    })
end
---@param obj RMCP.GenRakp2AuthCodeReq
function TGenRakp2AuthCodeReq:init_from_obj(obj)
    self.AuthAlgo = obj.AuthAlgo
    self.UserName = obj.UserName
    self.ConsoleSid = obj.ConsoleSid
    self.ManagedSid = obj.ManagedSid
    self.ConsoleRandom = obj.ConsoleRandom
    self.ManagedRandom = obj.ManagedRandom
    self.ManagedGuid = obj.ManagedGuid
    self.Role = obj.Role
    self.Ip = obj.Ip
end

function TGenRakp2AuthCodeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGenRakp2AuthCodeReq.group)
end

TGenRakp2AuthCodeReq.from_obj = TGenRakp2AuthCodeReq_from_obj

TGenRakp2AuthCodeReq.proto_property = {
    'AuthAlgo', 'UserName', 'ConsoleSid', 'ManagedSid', 'ConsoleRandom', 'ManagedRandom',
    'ManagedGuid', 'Role', 'Ip'
}

TGenRakp2AuthCodeReq.default = {0, '', 0, 0, {}, {}, {}, 0, ''}

TGenRakp2AuthCodeReq.struct = {
    {name = 'AuthAlgo', is_array = false, struct = nil},
    {name = 'UserName', is_array = false, struct = nil},
    {name = 'ConsoleSid', is_array = false, struct = nil},
    {name = 'ManagedSid', is_array = false, struct = nil},
    {name = 'ConsoleRandom', is_array = true, struct = nil},
    {name = 'ManagedRandom', is_array = true, struct = nil},
    {name = 'ManagedGuid', is_array = true, struct = nil},
    {name = 'Role', is_array = false, struct = nil}, {name = 'Ip', is_array = false, struct = nil}
}

function TGenRakp2AuthCodeReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'AuthAlgo', self.AuthAlgo, 'uint8', false, errs)
    validate.Required(prefix .. 'UserName', self.UserName, 'string', false, errs)
    validate.Required(prefix .. 'ConsoleSid', self.ConsoleSid, 'uint32', false, errs)
    validate.Required(prefix .. 'ManagedSid', self.ManagedSid, 'uint32', false, errs)
    validate.RequiredArray(prefix .. 'ConsoleRandom', self.ConsoleRandom, 'uint8', false, errs)
    validate.RequiredArray(prefix .. 'ManagedRandom', self.ManagedRandom, 'uint8', false, errs)
    validate.RequiredArray(prefix .. 'ManagedGuid', self.ManagedGuid, 'uint8', false, errs)
    validate.Required(prefix .. 'Role', self.Role, 'uint8', false, errs)
    validate.Required(prefix .. 'Ip', self.Ip, 'string', false, errs)

    validate.lens(prefix .. 'UserName', self.UserName, 1, 32, errs)
    validate.lens(prefix .. 'ConsoleRandom', self.ConsoleRandom, 16, 16, errs)
    validate.lens(prefix .. 'ManagedRandom', self.ManagedRandom, 16, 16, errs)
    validate.lens(prefix .. 'ManagedGuid', self.ManagedGuid, 16, 16, errs)

    TGenRakp2AuthCodeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGenRakp2AuthCodeReq.proto_property, errs)
    return self
end

function TGenRakp2AuthCodeReq:unpack(_)
    return self.AuthAlgo, self.UserName, self.ConsoleSid, self.ManagedSid, self.ConsoleRandom,
        self.ManagedRandom, self.ManagedGuid, self.Role, self.Ip
end

msg.GenRakp2AuthCodeReq = TGenRakp2AuthCodeReq

local RMCP = {}

local Mdb = require 'mc.mdb'

---@class RMCP: Table
RMCP.RMCP = Mdb.register_interface('bmc.kepler.AccountService.Authentication.RMCP', {}, {
    GenRakp2AuthCode = {'a{ss}ysuuayayayys', 'ay', msg.GenRakp2AuthCodeReq, msg.GenRakp2AuthCodeRsp},
    AuthRakp3 = {'a{ss}ysayuyays', '', msg.AuthRakp3Req, msg.AuthRakp3Rsp},
    GenSik = {'a{ss}ysayayys', 'ay', msg.GenSikReq, msg.GenSikRsp},
    GenRmcpAuthCode = {'a{ss}yayyuus', 'ay', msg.GenRmcpAuthCodeReq, msg.GenRmcpAuthCodeRsp}
}, {})
return RMCP
