-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class IDemoUnit.Method2Rsp
---@field r2 integer
local TMethod2Rsp = {}
TMethod2Rsp.__index = TMethod2Rsp
TMethod2Rsp.group = {}

local function TMethod2Rsp_from_obj(obj)
    return setmetatable(obj, TMethod2Rsp)
end

function TMethod2Rsp.new(r2)
    return TMethod2Rsp_from_obj({r2 = r2})
end
---@param obj IDemoUnit.Method2Rsp
function TMethod2Rsp:init_from_obj(obj)
    self.r2 = obj.r2
end

function TMethod2Rsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMethod2Rsp.group)
end

TMethod2Rsp.from_obj = TMethod2Rsp_from_obj

TMethod2Rsp.proto_property = {'r2'}

TMethod2Rsp.default = {0}

TMethod2Rsp.struct = {{name = 'r2', is_array = false, struct = nil}}

function TMethod2Rsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'r2', self.r2, 'int16', false, errs)

    TMethod2Rsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMethod2Rsp.proto_property, errs)
    return self
end

function TMethod2Rsp:unpack(_)
    return self.r2
end

msg.Method2Rsp = TMethod2Rsp

---@class IDemoUnit.Method2Req
---@field p3 integer
local TMethod2Req = {}
TMethod2Req.__index = TMethod2Req
TMethod2Req.group = {}

local function TMethod2Req_from_obj(obj)
    return setmetatable(obj, TMethod2Req)
end

function TMethod2Req.new(p3)
    return TMethod2Req_from_obj({p3 = p3})
end
---@param obj IDemoUnit.Method2Req
function TMethod2Req:init_from_obj(obj)
    self.p3 = obj.p3
end

function TMethod2Req:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMethod2Req.group)
end

TMethod2Req.from_obj = TMethod2Req_from_obj

TMethod2Req.proto_property = {'p3'}

TMethod2Req.default = {0}

TMethod2Req.struct = {{name = 'p3', is_array = false, struct = nil}}

function TMethod2Req:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'p3', self.p3, 'uint32', false, errs)

    TMethod2Req:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMethod2Req.proto_property, errs)
    return self
end

function TMethod2Req:unpack(_)
    return self.p3
end

msg.Method2Req = TMethod2Req

local IDemoUnit = {}

local Mdb = require 'mc.mdb'

---@class IDemoUnit: Table
IDemoUnit.IDemoUnit = Mdb.register_interface('bmc.demo.IDemoUnit', {}, {
    Method2 = {'a{ss}u', 'n', msg.Method2Req, msg.Method2Rsp}
}, {})
return IDemoUnit
