# mdb_interface

## 功能简介

**mdb_interface** 是 **资源协作接口** 的模型定义接口集合。该接口兼容 **D-Bus** 协议。具体的资源协作接口使用 **MDS** 方式进行描述。

**MDS（Module Description Source）** 是统一格式的组件（APP）模型定义源文件，对组件管理的数据、IPMI进行建模，同时也对组件的扩展和定制能力进行建模，其设计目标是整个系统以及开发工具具有相同的模型基础，工程框架基于模型源文件自动生成相关的配置文件（CSR/PSR的Schema）和代码（对象添加/删除、本地内存ORM、对接资源树、对接持久化服务、IPMI命令处理入口、RPC调用客户端、RPC调用服务端入口、http restful接口等），以达到简化组件开发的目的，组件开发人员主要围绕内存对象编写业务逻辑代码。

### mdb_interface 资源基础属性：

**mdb_interface** 中的资源定义总体上通过 **json** 格式进行描述，分为 **path** 和 **intf** 两部分。关于资源的具体资源属性说明如下表：

|资源基础属性|资源属性说明|资源样例|
|--|--|--|
|path|每个资源对象都被唯一的一个路径所描述，这个路径类似于文件系统|/bmc/kepler/Managers/1<br>*说明：上述路径表征管理系统1这个资源对象*|
|interface|每个资源对象是由若干个interface组成，每个interface可以认为是类型的某个具体实例，可以类比面向对象语言的类|bmc.kepler.Managers.Time<br>*说明：当前是管理系统的时间接口*|
|property|资源对象具体interface下的属性，可以类比面向对象语言的类属性|DateTime<br>*说明：在时间接口下有个属性是当前的具体时间*|
|method|资源对象具体interface下的方法，可以类比面向对象语言的类方法|SetDateTime<br>*说明：在时间接口下有个方法是设置当前时间*|
|signal|资源对象具体interface下的信号，可以自定义信号供下游进行订阅|FruAdded<br>*说明：FRU添加完毕之后发出信号，携带添加的Fru的ID和名称*|
|description|资源中基础属性的描述，可以存在于上述除path之外的所有属性中|--|

### mdb_interface 资源属性定义

**mdb_interface** 中的资源定义中关于 **property** 属性的定义，有多个层面的描述。具体如下表：

|属性定义关键字|属性定义描述|属性定义说明|定义样例|
|--|--|--|--|
|baseType|属性类型|表示该属性的类型，取值范围如下：<br><li>Boolean：布尔值<li>U8：1个字节无符号数<li>U8[]：1个字节无符号数数组<li>U16：2个字节无符号数<li>U16[]：2个字节无符号数数组<li>U32：4个字节无符号数<li>U32[]：4个字节无符号数数组<li>U64：8个字节无符号数<li>U64[]：8个字节无符号数数组<li>S16：2个字节有符号数<li>S16[]：2个字节有符号数数组<li>S32：4个字节有符号数<li>S32[]：4个字节有符号数数组<li>S64：8个字节有符号数<li>S64[]：8个字节有符号数数组<li>Double：双精度浮点数<li>Double[]：双精度浮点数数组<li>String：字符串<li>String[]：字符串数组|`"A": {"baseType": "U8"}`<br>*说明：属性A类型是1个字节的无符号数字*|
|default|属性默认值|表示属性默认值，根据类型给出即可<br>**说明：** 如果模型定义中没有明确给出，则自动填写默认值：字符串类型为空字符串，数字类型为0|`"A": {"default": "2"}`<br>*说明：属性A默认值为字符串的 "2"*|
|minimum|属性最小值|表示属性允许的最小值<br>**说明：** 仅对数字类型有效|`"A": {"baseType": "U8", "minimum": 2}`<br>*说明：属性A允许的最小值为 2*|
|maximum|属性最大值|表示属性允许的最大值<br>**说明：** 仅对数字类型有效|`"A": {"baseType": "U8", "maximum": 32}`<br>*说明：属性A允许的最大值为 32*|
|minLength|属性最小长度|表示属性允许的最小长度<br>**说明：** 仅对字符串类型有效|`"A": {"baseType": "String", "minLength": 2}`<br>*说明：属性A允许的最小长度为 2*|
|maxLength|属性最大长度|表示属性允许的最大长度<br>**说明：** 仅对字符串类型有效|`"A": {"baseType": "String", "maxLength": 32}`<br>*说明：属性A允许的最大长度为 32*|
|pattern|属性格式|表示属性要满足的格式<br>**说明：** 仅对字符串类型有效|`"A": {"baseType": "String", "pattern": "^(\\([0-9]{3}\\))?[0-9]{3}-[0-9]{4}$"}`<br>*说明：属性A的值必须满足定义的模式匹配*|

## 配置介绍（如果组件需要配置，则需要描述配置项及如何配置）

**mdb_interface** 是 D-Bus 资源的集合体，承载着所有的 D-Bus 的接口资源，因此配置之前需要进行评审。具体的评审会议由开源SIG进行组织。

- 社区TC会议组织：[Go](https://gitcode.com/openUBMC/community/blob/main/README.md)

