-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local common        = {}

common.PCB_VERSION                  = 0x00
common.BMC_MAIN_VERSION             = 0x01
common.CPLD_VERSION                 = 0x02
common.FPGA_VERSION                 = 0x03
common.SDR_VERSION                  = 0x05
common.BIOS_VERSION                 = 0x06
common.UBOOT_VERSION                = 0x08
common.BMC_BACKUP_VERSION           = 0x0c
common.UBOOT_BACKUP_VERSION         = 0x10
common.BMC_AVAILABLE_VERSION        = 0x18
common.SR_VERSION                   = 0x19
common.VRD_VERSION                  = 0x1A
common.MCU_VERSION                  = 0x1B
common.PSIP_VERSION                 = 0x1C
common.COPROCESSOR_VERSION          = 0x1D
common.ALL_VERSION                  = 0xFF

common.version_key_list={
    [common.PCB_VERSION] =              "PcbVersion",
    [common.BMC_MAIN_VERSION] =         "MainPMEVer",
    [common.CPLD_VERSION] =             "CPLDVer",
    [common.FPGA_VERSION] =             "FPGAVer",
    [common.SDR_VERSION] =              "SdrVer",
    [common.BIOS_VERSION] =             "BiosVer",
    [common.UBOOT_VERSION] =            "UbootVer",
    [common.BMC_BACKUP_VERSION] =       "BackupPMEVer",
    [common.UBOOT_BACKUP_VERSION] =     "BackupUbootVer",
    [common.BMC_AVAILABLE_VERSION] =    "AvailablePMEVer",
    [common.SR_VERSION] =               "HWSRVer",
    [common.VRD_VERSION] =              "VRDVer",
    [common.MCU_VERSION] =              "MCUVer",
    [common.PSIP_VERSION] =             "PSIPVer",
    [common.COPROCESSOR_VERSION] =      "COPROCESSORVer"
}

return common
