-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local CpuBoard = {}

---@class CpuBoard.BIOSVersion
---@field BIOSVersion string
local TBIOSVersion = {}
TBIOSVersion.__index = TBIOSVersion
TBIOSVersion.group = {}

local function TBIOSVersion_from_obj(obj)
    return setmetatable(obj, TBIOSVersion)
end

function TBIOSVersion.new(BIOSVersion)
    return TBIOSVersion_from_obj({BIOSVersion = BIOSVersion})
end
---@param obj CpuBoard.BIOSVersion
function TBIOSVersion:init_from_obj(obj)
    self.BIOSVersion = obj.BIOSVersion
end

function TBIOSVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBIOSVersion.group)
end

TBIOSVersion.from_obj = TBIOSVersion_from_obj

TBIOSVersion.proto_property = {'BIOSVersion'}

TBIOSVersion.default = {''}

TBIOSVersion.struct = {{name = 'BIOSVersion', is_array = false, struct = nil}}

function TBIOSVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BIOSVersion', self.BIOSVersion, 'string', true, errs, need_convert)

    TBIOSVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBIOSVersion.proto_property, errs, need_convert)
    return self
end

function TBIOSVersion:unpack(_)
    return self.BIOSVersion
end

CpuBoard.BIOSVersion = TBIOSVersion

---@class CpuBoard.Platform
---@field Platform integer
local TPlatform = {}
TPlatform.__index = TPlatform
TPlatform.group = {}

local function TPlatform_from_obj(obj)
    return setmetatable(obj, TPlatform)
end

function TPlatform.new(Platform)
    return TPlatform_from_obj({Platform = Platform})
end
---@param obj CpuBoard.Platform
function TPlatform:init_from_obj(obj)
    self.Platform = obj.Platform
end

function TPlatform:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPlatform.group)
end

TPlatform.from_obj = TPlatform_from_obj

TPlatform.proto_property = {'Platform'}

TPlatform.default = {0}

TPlatform.struct = {{name = 'Platform', is_array = false, struct = nil}}

function TPlatform:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Platform', self.Platform, 'uint8', true, errs, need_convert)

    TPlatform:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPlatform.proto_property, errs, need_convert)
    return self
end

function TPlatform:unpack(_)
    return self.Platform
end

CpuBoard.Platform = TPlatform

CpuBoard.interface = mdb.register_interface('bmc.kepler.Systems.Board.CpuBoard', {
    Platform = {'y', nil, true, nil, false},
    BIOSVersion = {'s', nil, true, nil, false}
}, {}, {})

return CpuBoard
