--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local StartDftTest = {}

---@class ManufactureIpmiCmds.StartDftTestReq
---@field ReadOffset integer
---@field ReadLength integer
---@field Type integer
---@field Command integer
---@field Index integer
---@field Tail string
local TStartDftTestReq = {}
TStartDftTestReq.__index = TStartDftTestReq
TStartDftTestReq.group = {}

local function TStartDftTestReq_from_obj(obj)
    return setmetatable(obj, TStartDftTestReq)
end

function TStartDftTestReq.new(ReadOffset, ReadLength, Type, Command, Index, Tail)
    return TStartDftTestReq_from_obj({
        ReadOffset = ReadOffset,
        ReadLength = ReadLength,
        Type = Type,
        Command = Command,
        Index = Index,
        Tail = Tail
    })
end
---@param obj ManufactureIpmiCmds.StartDftTestReq
function TStartDftTestReq:init_from_obj(obj)
    self.ReadOffset = obj.ReadOffset
    self.ReadLength = obj.ReadLength
    self.Type = obj.Type
    self.Command = obj.Command
    self.Index = obj.Index
    self.Tail = obj.Tail
end

function TStartDftTestReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStartDftTestReq.group)
end

TStartDftTestReq.from_obj = TStartDftTestReq_from_obj

TStartDftTestReq.proto_property = {'ReadOffset', 'ReadLength', 'Type', 'Command', 'Index', 'Tail'}

TStartDftTestReq.default = {0, 0, 0, 0, 0, ''}

TStartDftTestReq.struct = {
    {name = 'ReadOffset', is_array = false, struct = nil}, {name = 'ReadLength', is_array = false, struct = nil},
    {name = 'Type', is_array = false, struct = nil}, {name = 'Command', is_array = false, struct = nil},
    {name = 'Index', is_array = false, struct = nil}, {name = 'Tail', is_array = false, struct = nil}
}

function TStartDftTestReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ReadOffset', self.ReadOffset, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadLength', self.ReadLength, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Type', self.Type, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Command', self.Command, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Index', self.Index, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Tail', self.Tail, 'string', false, errs, need_convert)

    TStartDftTestReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStartDftTestReq.proto_property, errs, need_convert)
    return self
end

function TStartDftTestReq:unpack(_)
    return self.ReadOffset, self.ReadLength, self.Type, self.Command, self.Index, self.Tail
end

StartDftTest.StartDftTestReq = TStartDftTestReq

---@class ManufactureIpmiCmds.StartDftTestRsp
---@field CompletionCode integer
---@field EndOfList integer
---@field Display string
local TStartDftTestRsp = {}
TStartDftTestRsp.__index = TStartDftTestRsp
TStartDftTestRsp.group = {}

local function TStartDftTestRsp_from_obj(obj)
    return setmetatable(obj, TStartDftTestRsp)
end

function TStartDftTestRsp.new(CompletionCode, EndOfList, Display)
    return TStartDftTestRsp_from_obj({CompletionCode = CompletionCode, EndOfList = EndOfList, Display = Display})
end
---@param obj ManufactureIpmiCmds.StartDftTestRsp
function TStartDftTestRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.EndOfList = obj.EndOfList
    self.Display = obj.Display
end

function TStartDftTestRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStartDftTestRsp.group)
end

TStartDftTestRsp.from_obj = TStartDftTestRsp_from_obj

TStartDftTestRsp.proto_property = {'CompletionCode', 'EndOfList', 'Display'}

TStartDftTestRsp.default = {0, 0, ''}

TStartDftTestRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'EndOfList', is_array = false, struct = nil},
    {name = 'Display', is_array = false, struct = nil}
}

function TStartDftTestRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'EndOfList', self.EndOfList, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Display', self.Display, 'string', false, errs, need_convert)

    TStartDftTestRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStartDftTestRsp.proto_property, errs, need_convert)
    return self
end

function TStartDftTestRsp:unpack(_)
    return self.CompletionCode, self.EndOfList, self.Display
end

StartDftTest.StartDftTestRsp = TStartDftTestRsp

return StartDftTest
