--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetChipInfo = {}

---@class ManufactureIpmiCmds.SetChipInfoReq
---@field ComponentType integer
---@field ComponentSlot integer
---@field ChipType integer
---@field LinkFlag integer
---@field Offset integer
---@field Length integer
---@field Data integer
local TSetChipInfoReq = {}
TSetChipInfoReq.__index = TSetChipInfoReq
TSetChipInfoReq.group = {}

local function TSetChipInfoReq_from_obj(obj)
    return setmetatable(obj, TSetChipInfoReq)
end

function TSetChipInfoReq.new(ComponentType, ComponentSlot, ChipType, LinkFlag, Offset, Length, Data)
    return TSetChipInfoReq_from_obj({
        ComponentType = ComponentType,
        ComponentSlot = ComponentSlot,
        ChipType = ChipType,
        LinkFlag = LinkFlag,
        Offset = Offset,
        Length = Length,
        Data = Data
    })
end
---@param obj ManufactureIpmiCmds.SetChipInfoReq
function TSetChipInfoReq:init_from_obj(obj)
    self.ComponentType = obj.ComponentType
    self.ComponentSlot = obj.ComponentSlot
    self.ChipType = obj.ChipType
    self.LinkFlag = obj.LinkFlag
    self.Offset = obj.Offset
    self.Length = obj.Length
    self.Data = obj.Data
end

function TSetChipInfoReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetChipInfoReq.group)
end

TSetChipInfoReq.from_obj = TSetChipInfoReq_from_obj

TSetChipInfoReq.proto_property = {'ComponentType', 'ComponentSlot', 'ChipType', 'LinkFlag', 'Offset', 'Length', 'Data'}

TSetChipInfoReq.default = {0, 0, 0, 0, 0, 0, 0}

TSetChipInfoReq.struct = {
    {name = 'ComponentType', is_array = false, struct = nil}, {name = 'ComponentSlot', is_array = false, struct = nil},
    {name = 'ChipType', is_array = false, struct = nil}, {name = 'LinkFlag', is_array = false, struct = nil},
    {name = 'Offset', is_array = false, struct = nil}, {name = 'Length', is_array = false, struct = nil},
    {name = 'Data', is_array = false, struct = nil}
}

function TSetChipInfoReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ComponentType', self.ComponentType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ComponentSlot', self.ComponentSlot, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ChipType', self.ChipType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'LinkFlag', self.LinkFlag, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Offset', self.Offset, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'uint8', false, errs, need_convert)

    TSetChipInfoReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetChipInfoReq.proto_property, errs, need_convert)
    return self
end

function TSetChipInfoReq:unpack(_)
    return self.ComponentType, self.ComponentSlot, self.ChipType, self.LinkFlag, self.Offset, self.Length, self.Data
end

SetChipInfo.SetChipInfoReq = TSetChipInfoReq

---@class ManufactureIpmiCmds.SetChipInfoRsp
---@field CompletionCode integer
local TSetChipInfoRsp = {}
TSetChipInfoRsp.__index = TSetChipInfoRsp
TSetChipInfoRsp.group = {}

local function TSetChipInfoRsp_from_obj(obj)
    return setmetatable(obj, TSetChipInfoRsp)
end

function TSetChipInfoRsp.new(CompletionCode)
    return TSetChipInfoRsp_from_obj({CompletionCode = CompletionCode})
end
---@param obj ManufactureIpmiCmds.SetChipInfoRsp
function TSetChipInfoRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
end

function TSetChipInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetChipInfoRsp.group)
end

TSetChipInfoRsp.from_obj = TSetChipInfoRsp_from_obj

TSetChipInfoRsp.proto_property = {'CompletionCode'}

TSetChipInfoRsp.default = {0}

TSetChipInfoRsp.struct = {{name = 'CompletionCode', is_array = false, struct = nil}}

function TSetChipInfoRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)

    TSetChipInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetChipInfoRsp.proto_property, errs, need_convert)
    return self
end

function TSetChipInfoRsp:unpack(_)
    return self.CompletionCode
end

SetChipInfo.SetChipInfoRsp = TSetChipInfoRsp

return SetChipInfo
