--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local ReadVersionData = {}

---@class ManufactureIpmiCmds.ReadVersionDataReq
---@field FruId integer
---@field VerType integer
---@field Offset integer
---@field Length integer
local TReadVersionDataReq = {}
TReadVersionDataReq.__index = TReadVersionDataReq
TReadVersionDataReq.group = {}

local function TReadVersionDataReq_from_obj(obj)
    return setmetatable(obj, TReadVersionDataReq)
end

function TReadVersionDataReq.new(FruId, VerType, Offset, Length)
    return TReadVersionDataReq_from_obj({FruId = FruId, VerType = VerType, Offset = Offset, Length = Length})
end
---@param obj ManufactureIpmiCmds.ReadVersionDataReq
function TReadVersionDataReq:init_from_obj(obj)
    self.FruId = obj.FruId
    self.VerType = obj.VerType
    self.Offset = obj.Offset
    self.Length = obj.Length
end

function TReadVersionDataReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TReadVersionDataReq.group)
end

TReadVersionDataReq.from_obj = TReadVersionDataReq_from_obj

TReadVersionDataReq.proto_property = {'FruId', 'VerType', 'Offset', 'Length'}

TReadVersionDataReq.default = {0, 0, 0, 0}

TReadVersionDataReq.struct = {
    {name = 'FruId', is_array = false, struct = nil}, {name = 'VerType', is_array = false, struct = nil},
    {name = 'Offset', is_array = false, struct = nil}, {name = 'Length', is_array = false, struct = nil}
}

function TReadVersionDataReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FruId', self.FruId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'VerType', self.VerType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Offset', self.Offset, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)

    TReadVersionDataReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TReadVersionDataReq.proto_property, errs, need_convert)
    return self
end

function TReadVersionDataReq:unpack(_)
    return self.FruId, self.VerType, self.Offset, self.Length
end

ReadVersionData.ReadVersionDataReq = TReadVersionDataReq

---@class ManufactureIpmiCmds.ReadVersionDataRsp
---@field CompletionCode integer
---@field EndOfList integer
---@field Data string
local TReadVersionDataRsp = {}
TReadVersionDataRsp.__index = TReadVersionDataRsp
TReadVersionDataRsp.group = {}

local function TReadVersionDataRsp_from_obj(obj)
    return setmetatable(obj, TReadVersionDataRsp)
end

function TReadVersionDataRsp.new(CompletionCode, EndOfList, Data)
    return TReadVersionDataRsp_from_obj({CompletionCode = CompletionCode, EndOfList = EndOfList, Data = Data})
end
---@param obj ManufactureIpmiCmds.ReadVersionDataRsp
function TReadVersionDataRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.EndOfList = obj.EndOfList
    self.Data = obj.Data
end

function TReadVersionDataRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TReadVersionDataRsp.group)
end

TReadVersionDataRsp.from_obj = TReadVersionDataRsp_from_obj

TReadVersionDataRsp.proto_property = {'CompletionCode', 'EndOfList', 'Data'}

TReadVersionDataRsp.default = {0, 0, ''}

TReadVersionDataRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'EndOfList', is_array = false, struct = nil},
    {name = 'Data', is_array = false, struct = nil}
}

function TReadVersionDataRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'EndOfList', self.EndOfList, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TReadVersionDataRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TReadVersionDataRsp.proto_property, errs, need_convert)
    return self
end

function TReadVersionDataRsp:unpack(_)
    return self.CompletionCode, self.EndOfList, self.Data
end

ReadVersionData.ReadVersionDataRsp = TReadVersionDataRsp

return ReadVersionData
