--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local ImportImageToGpu = {}

---@class ManufactureIpmiCmds.ImportImageToGpuReq
---@field Length integer
---@field Width integer
---@field Bpp integer
---@field Path string
local TImportImageToGpuReq = {}
TImportImageToGpuReq.__index = TImportImageToGpuReq
TImportImageToGpuReq.group = {}

local function TImportImageToGpuReq_from_obj(obj)
    return setmetatable(obj, TImportImageToGpuReq)
end

function TImportImageToGpuReq.new(Length, Width, Bpp, Path)
    return TImportImageToGpuReq_from_obj({Length = Length, Width = Width, Bpp = Bpp, Path = Path})
end
---@param obj ManufactureIpmiCmds.ImportImageToGpuReq
function TImportImageToGpuReq:init_from_obj(obj)
    self.Length = obj.Length
    self.Width = obj.Width
    self.Bpp = obj.Bpp
    self.Path = obj.Path
end

function TImportImageToGpuReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TImportImageToGpuReq.group)
end

TImportImageToGpuReq.from_obj = TImportImageToGpuReq_from_obj

TImportImageToGpuReq.proto_property = {'Length', 'Width', 'Bpp', 'Path'}

TImportImageToGpuReq.default = {0, 0, 0, ''}

TImportImageToGpuReq.struct = {
    {name = 'Length', is_array = false, struct = nil}, {name = 'Width', is_array = false, struct = nil},
    {name = 'Bpp', is_array = false, struct = nil}, {name = 'Path', is_array = false, struct = nil}
}

function TImportImageToGpuReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Length', self.Length, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Width', self.Width, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Bpp', self.Bpp, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Path', self.Path, 'string', false, errs, need_convert)

    TImportImageToGpuReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TImportImageToGpuReq.proto_property, errs, need_convert)
    return self
end

function TImportImageToGpuReq:unpack(_)
    return self.Length, self.Width, self.Bpp, self.Path
end

ImportImageToGpu.ImportImageToGpuReq = TImportImageToGpuReq

---@class ManufactureIpmiCmds.ImportImageToGpuRsp
---@field CompletionCode integer
local TImportImageToGpuRsp = {}
TImportImageToGpuRsp.__index = TImportImageToGpuRsp
TImportImageToGpuRsp.group = {}

local function TImportImageToGpuRsp_from_obj(obj)
    return setmetatable(obj, TImportImageToGpuRsp)
end

function TImportImageToGpuRsp.new(CompletionCode)
    return TImportImageToGpuRsp_from_obj({CompletionCode = CompletionCode})
end
---@param obj ManufactureIpmiCmds.ImportImageToGpuRsp
function TImportImageToGpuRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
end

function TImportImageToGpuRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TImportImageToGpuRsp.group)
end

TImportImageToGpuRsp.from_obj = TImportImageToGpuRsp_from_obj

TImportImageToGpuRsp.proto_property = {'CompletionCode'}

TImportImageToGpuRsp.default = {0}

TImportImageToGpuRsp.struct = {{name = 'CompletionCode', is_array = false, struct = nil}}

function TImportImageToGpuRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)

    TImportImageToGpuRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TImportImageToGpuRsp.proto_property, errs, need_convert)
    return self
end

function TImportImageToGpuRsp:unpack(_)
    return self.CompletionCode
end

ImportImageToGpu.ImportImageToGpuRsp = TImportImageToGpuRsp

return ImportImageToGpu
