--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetTestType = {}

---@class ManufactureIpmiCmds.GetTestTypeReq
---@field FRUDeviceID integer
---@field TestType integer
local TGetTestTypeReq = {}
TGetTestTypeReq.__index = TGetTestTypeReq
TGetTestTypeReq.group = {}

local function TGetTestTypeReq_from_obj(obj)
    return setmetatable(obj, TGetTestTypeReq)
end

function TGetTestTypeReq.new(FRUDeviceID, TestType)
    return TGetTestTypeReq_from_obj({FRUDeviceID = FRUDeviceID, TestType = TestType})
end
---@param obj ManufactureIpmiCmds.GetTestTypeReq
function TGetTestTypeReq:init_from_obj(obj)
    self.FRUDeviceID = obj.FRUDeviceID
    self.TestType = obj.TestType
end

function TGetTestTypeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetTestTypeReq.group)
end

TGetTestTypeReq.from_obj = TGetTestTypeReq_from_obj

TGetTestTypeReq.proto_property = {'FRUDeviceID', 'TestType'}

TGetTestTypeReq.default = {0, 0}

TGetTestTypeReq.struct = {
    {name = 'FRUDeviceID', is_array = false, struct = nil}, {name = 'TestType', is_array = false, struct = nil}
}

function TGetTestTypeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FRUDeviceID', self.FRUDeviceID, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'TestType', self.TestType, 'uint8', false, errs, need_convert)

    TGetTestTypeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetTestTypeReq.proto_property, errs, need_convert)
    return self
end

function TGetTestTypeReq:unpack(_)
    return self.FRUDeviceID, self.TestType
end

GetTestType.GetTestTypeReq = TGetTestTypeReq

---@class ManufactureIpmiCmds.GetTestTypeRsp
---@field CompletionCode integer
---@field Open integer
---@field TestType integer
local TGetTestTypeRsp = {}
TGetTestTypeRsp.__index = TGetTestTypeRsp
TGetTestTypeRsp.group = {}

local function TGetTestTypeRsp_from_obj(obj)
    return setmetatable(obj, TGetTestTypeRsp)
end

function TGetTestTypeRsp.new(CompletionCode, Open, TestType)
    return TGetTestTypeRsp_from_obj({CompletionCode = CompletionCode, Open = Open, TestType = TestType})
end
---@param obj ManufactureIpmiCmds.GetTestTypeRsp
function TGetTestTypeRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.Open = obj.Open
    self.TestType = obj.TestType
end

function TGetTestTypeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetTestTypeRsp.group)
end

TGetTestTypeRsp.from_obj = TGetTestTypeRsp_from_obj

TGetTestTypeRsp.proto_property = {'CompletionCode', 'Open', 'TestType'}

TGetTestTypeRsp.default = {0, 0, 0}

TGetTestTypeRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'Open', is_array = false, struct = nil},
    {name = 'TestType', is_array = false, struct = nil}
}

function TGetTestTypeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Open', self.Open, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'TestType', self.TestType, 'uint8', false, errs, need_convert)

    TGetTestTypeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetTestTypeRsp.proto_property, errs, need_convert)
    return self
end

function TGetTestTypeRsp:unpack(_)
    return self.CompletionCode, self.Open, self.TestType
end

GetTestType.GetTestTypeRsp = TGetTestTypeRsp

return GetTestType
