--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetTestItemInfo = {}

---@class ManufactureIpmiCmds.GetTestItemInfoReq
---@field ReadOffset integer
---@field ReadLength integer
---@field Type integer
---@field Command integer
---@field Tail string
local TGetTestItemInfoReq = {}
TGetTestItemInfoReq.__index = TGetTestItemInfoReq
TGetTestItemInfoReq.group = {}

local function TGetTestItemInfoReq_from_obj(obj)
    return setmetatable(obj, TGetTestItemInfoReq)
end

function TGetTestItemInfoReq.new(ReadOffset, ReadLength, Type, Command, Tail)
    return TGetTestItemInfoReq_from_obj({
        ReadOffset = ReadOffset,
        ReadLength = ReadLength,
        Type = Type,
        Command = Command,
        Tail = Tail
    })
end
---@param obj ManufactureIpmiCmds.GetTestItemInfoReq
function TGetTestItemInfoReq:init_from_obj(obj)
    self.ReadOffset = obj.ReadOffset
    self.ReadLength = obj.ReadLength
    self.Type = obj.Type
    self.Command = obj.Command
    self.Tail = obj.Tail
end

function TGetTestItemInfoReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetTestItemInfoReq.group)
end

TGetTestItemInfoReq.from_obj = TGetTestItemInfoReq_from_obj

TGetTestItemInfoReq.proto_property = {'ReadOffset', 'ReadLength', 'Type', 'Command', 'Tail'}

TGetTestItemInfoReq.default = {0, 0, 0, 0, ''}

TGetTestItemInfoReq.struct = {
    {name = 'ReadOffset', is_array = false, struct = nil}, {name = 'ReadLength', is_array = false, struct = nil},
    {name = 'Type', is_array = false, struct = nil}, {name = 'Command', is_array = false, struct = nil},
    {name = 'Tail', is_array = false, struct = nil}
}

function TGetTestItemInfoReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ReadOffset', self.ReadOffset, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadLength', self.ReadLength, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Type', self.Type, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Command', self.Command, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Tail', self.Tail, 'string', false, errs, need_convert)

    TGetTestItemInfoReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetTestItemInfoReq.proto_property, errs, need_convert)
    return self
end

function TGetTestItemInfoReq:unpack(_)
    return self.ReadOffset, self.ReadLength, self.Type, self.Command, self.Tail
end

GetTestItemInfo.GetTestItemInfoReq = TGetTestItemInfoReq

---@class ManufactureIpmiCmds.GetTestItemInfoRsp
---@field CompletionCode integer
---@field EndOfList integer
---@field Tail string
local TGetTestItemInfoRsp = {}
TGetTestItemInfoRsp.__index = TGetTestItemInfoRsp
TGetTestItemInfoRsp.group = {}

local function TGetTestItemInfoRsp_from_obj(obj)
    return setmetatable(obj, TGetTestItemInfoRsp)
end

function TGetTestItemInfoRsp.new(CompletionCode, EndOfList, Tail)
    return TGetTestItemInfoRsp_from_obj({CompletionCode = CompletionCode, EndOfList = EndOfList, Tail = Tail})
end
---@param obj ManufactureIpmiCmds.GetTestItemInfoRsp
function TGetTestItemInfoRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.EndOfList = obj.EndOfList
    self.Tail = obj.Tail
end

function TGetTestItemInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetTestItemInfoRsp.group)
end

TGetTestItemInfoRsp.from_obj = TGetTestItemInfoRsp_from_obj

TGetTestItemInfoRsp.proto_property = {'CompletionCode', 'EndOfList', 'Tail'}

TGetTestItemInfoRsp.default = {0, 0, ''}

TGetTestItemInfoRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'EndOfList', is_array = false, struct = nil},
    {name = 'Tail', is_array = false, struct = nil}
}

function TGetTestItemInfoRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'EndOfList', self.EndOfList, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Tail', self.Tail, 'string', false, errs, need_convert)

    TGetTestItemInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetTestItemInfoRsp.proto_property, errs, need_convert)
    return self
end

function TGetTestItemInfoRsp:unpack(_)
    return self.CompletionCode, self.EndOfList, self.Tail
end

GetTestItemInfo.GetTestItemInfoRsp = TGetTestItemInfoRsp

return GetTestItemInfo
