--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetProcessTime = {}

---@class ManufactureIpmiCmds.GetProcessTimeReq
---@field Type integer
---@field Tail string
local TGetProcessTimeReq = {}
TGetProcessTimeReq.__index = TGetProcessTimeReq
TGetProcessTimeReq.group = {}

local function TGetProcessTimeReq_from_obj(obj)
    return setmetatable(obj, TGetProcessTimeReq)
end

function TGetProcessTimeReq.new(Type, Tail)
    return TGetProcessTimeReq_from_obj({Type = Type, Tail = Tail})
end
---@param obj ManufactureIpmiCmds.GetProcessTimeReq
function TGetProcessTimeReq:init_from_obj(obj)
    self.Type = obj.Type
    self.Tail = obj.Tail
end

function TGetProcessTimeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetProcessTimeReq.group)
end

TGetProcessTimeReq.from_obj = TGetProcessTimeReq_from_obj

TGetProcessTimeReq.proto_property = {'Type', 'Tail'}

TGetProcessTimeReq.default = {0, ''}

TGetProcessTimeReq.struct = {
    {name = 'Type', is_array = false, struct = nil}, {name = 'Tail', is_array = false, struct = nil}
}

function TGetProcessTimeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Type', self.Type, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Tail', self.Tail, 'string', false, errs, need_convert)

    TGetProcessTimeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetProcessTimeReq.proto_property, errs, need_convert)
    return self
end

function TGetProcessTimeReq:unpack(_)
    return self.Type, self.Tail
end

GetProcessTime.GetProcessTimeReq = TGetProcessTimeReq

---@class ManufactureIpmiCmds.GetProcessTimeRsp
---@field CompletionCode integer
---@field Time integer
local TGetProcessTimeRsp = {}
TGetProcessTimeRsp.__index = TGetProcessTimeRsp
TGetProcessTimeRsp.group = {}

local function TGetProcessTimeRsp_from_obj(obj)
    return setmetatable(obj, TGetProcessTimeRsp)
end

function TGetProcessTimeRsp.new(CompletionCode, Time)
    return TGetProcessTimeRsp_from_obj({CompletionCode = CompletionCode, Time = Time})
end
---@param obj ManufactureIpmiCmds.GetProcessTimeRsp
function TGetProcessTimeRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.Time = obj.Time
end

function TGetProcessTimeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetProcessTimeRsp.group)
end

TGetProcessTimeRsp.from_obj = TGetProcessTimeRsp_from_obj

TGetProcessTimeRsp.proto_property = {'CompletionCode', 'Time'}

TGetProcessTimeRsp.default = {0, 0}

TGetProcessTimeRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'Time', is_array = false, struct = nil}
}

function TGetProcessTimeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Time', self.Time, 'uint16', false, errs, need_convert)

    TGetProcessTimeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetProcessTimeRsp.proto_property, errs, need_convert)
    return self
end

function TGetProcessTimeRsp:unpack(_)
    return self.CompletionCode, self.Time
end

GetProcessTime.GetProcessTimeRsp = TGetProcessTimeRsp

return GetProcessTime
