--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetDftResult = {}

---@class ManufactureIpmiCmds.GetDftResultReq
---@field ReadOffset integer
---@field ReadLength integer
---@field Type integer
---@field Command integer
---@field Tail string
local TGetDftResultReq = {}
TGetDftResultReq.__index = TGetDftResultReq
TGetDftResultReq.group = {}

local function TGetDftResultReq_from_obj(obj)
    return setmetatable(obj, TGetDftResultReq)
end

function TGetDftResultReq.new(ReadOffset, ReadLength, Type, Command, Tail)
    return TGetDftResultReq_from_obj({
        ReadOffset = ReadOffset,
        ReadLength = ReadLength,
        Type = Type,
        Command = Command,
        Tail = Tail
    })
end
---@param obj ManufactureIpmiCmds.GetDftResultReq
function TGetDftResultReq:init_from_obj(obj)
    self.ReadOffset = obj.ReadOffset
    self.ReadLength = obj.ReadLength
    self.Type = obj.Type
    self.Command = obj.Command
    self.Tail = obj.Tail
end

function TGetDftResultReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDftResultReq.group)
end

TGetDftResultReq.from_obj = TGetDftResultReq_from_obj

TGetDftResultReq.proto_property = {'ReadOffset', 'ReadLength', 'Type', 'Command', 'Tail'}

TGetDftResultReq.default = {0, 0, 0, 0, ''}

TGetDftResultReq.struct = {
    {name = 'ReadOffset', is_array = false, struct = nil}, {name = 'ReadLength', is_array = false, struct = nil},
    {name = 'Type', is_array = false, struct = nil}, {name = 'Command', is_array = false, struct = nil},
    {name = 'Tail', is_array = false, struct = nil}
}

function TGetDftResultReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ReadOffset', self.ReadOffset, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadLength', self.ReadLength, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Type', self.Type, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Command', self.Command, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Tail', self.Tail, 'string', false, errs, need_convert)

    TGetDftResultReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDftResultReq.proto_property, errs, need_convert)
    return self
end

function TGetDftResultReq:unpack(_)
    return self.ReadOffset, self.ReadLength, self.Type, self.Command, self.Tail
end

GetDftResult.GetDftResultReq = TGetDftResultReq

---@class ManufactureIpmiCmds.GetDftResultRsp
---@field CompletionCode integer
---@field EndOfList integer
---@field Display string
local TGetDftResultRsp = {}
TGetDftResultRsp.__index = TGetDftResultRsp
TGetDftResultRsp.group = {}

local function TGetDftResultRsp_from_obj(obj)
    return setmetatable(obj, TGetDftResultRsp)
end

function TGetDftResultRsp.new(CompletionCode, EndOfList, Display)
    return TGetDftResultRsp_from_obj({CompletionCode = CompletionCode, EndOfList = EndOfList, Display = Display})
end
---@param obj ManufactureIpmiCmds.GetDftResultRsp
function TGetDftResultRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.EndOfList = obj.EndOfList
    self.Display = obj.Display
end

function TGetDftResultRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDftResultRsp.group)
end

TGetDftResultRsp.from_obj = TGetDftResultRsp_from_obj

TGetDftResultRsp.proto_property = {'CompletionCode', 'EndOfList', 'Display'}

TGetDftResultRsp.default = {0, 0, ''}

TGetDftResultRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'EndOfList', is_array = false, struct = nil},
    {name = 'Display', is_array = false, struct = nil}
}

function TGetDftResultRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'EndOfList', self.EndOfList, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Display', self.Display, 'string', false, errs, need_convert)

    TGetDftResultRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDftResultRsp.proto_property, errs, need_convert)
    return self
end

function TGetDftResultRsp:unpack(_)
    return self.CompletionCode, self.EndOfList, self.Display
end

GetDftResult.GetDftResultRsp = TGetDftResultRsp

return GetDftResult
