--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetChipInfo = {}

---@class ManufactureIpmiCmds.GetChipInfoReq
---@field ComponentType integer
---@field ComponentSlot integer
---@field ChipType integer
---@field Offset integer
---@field Length integer
local TGetChipInfoReq = {}
TGetChipInfoReq.__index = TGetChipInfoReq
TGetChipInfoReq.group = {}

local function TGetChipInfoReq_from_obj(obj)
    return setmetatable(obj, TGetChipInfoReq)
end

function TGetChipInfoReq.new(ComponentType, ComponentSlot, ChipType, Offset, Length)
    return TGetChipInfoReq_from_obj({
        ComponentType = ComponentType,
        ComponentSlot = ComponentSlot,
        ChipType = ChipType,
        Offset = Offset,
        Length = Length
    })
end
---@param obj ManufactureIpmiCmds.GetChipInfoReq
function TGetChipInfoReq:init_from_obj(obj)
    self.ComponentType = obj.ComponentType
    self.ComponentSlot = obj.ComponentSlot
    self.ChipType = obj.ChipType
    self.Offset = obj.Offset
    self.Length = obj.Length
end

function TGetChipInfoReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetChipInfoReq.group)
end

TGetChipInfoReq.from_obj = TGetChipInfoReq_from_obj

TGetChipInfoReq.proto_property = {'ComponentType', 'ComponentSlot', 'ChipType', 'Offset', 'Length'}

TGetChipInfoReq.default = {0, 0, 0, 0, 0}

TGetChipInfoReq.struct = {
    {name = 'ComponentType', is_array = false, struct = nil}, {name = 'ComponentSlot', is_array = false, struct = nil},
    {name = 'ChipType', is_array = false, struct = nil}, {name = 'Offset', is_array = false, struct = nil},
    {name = 'Length', is_array = false, struct = nil}
}

function TGetChipInfoReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ComponentType', self.ComponentType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ComponentSlot', self.ComponentSlot, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ChipType', self.ChipType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Offset', self.Offset, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)

    TGetChipInfoReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetChipInfoReq.proto_property, errs, need_convert)
    return self
end

function TGetChipInfoReq:unpack(_)
    return self.ComponentType, self.ComponentSlot, self.ChipType, self.Offset, self.Length
end

GetChipInfo.GetChipInfoReq = TGetChipInfoReq

---@class ManufactureIpmiCmds.GetChipInfoRsp
---@field CompletionCode integer
---@field EndOfList integer
---@field Data string
local TGetChipInfoRsp = {}
TGetChipInfoRsp.__index = TGetChipInfoRsp
TGetChipInfoRsp.group = {}

local function TGetChipInfoRsp_from_obj(obj)
    return setmetatable(obj, TGetChipInfoRsp)
end

function TGetChipInfoRsp.new(CompletionCode, EndOfList, Data)
    return TGetChipInfoRsp_from_obj({CompletionCode = CompletionCode, EndOfList = EndOfList, Data = Data})
end
---@param obj ManufactureIpmiCmds.GetChipInfoRsp
function TGetChipInfoRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.EndOfList = obj.EndOfList
    self.Data = obj.Data
end

function TGetChipInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetChipInfoRsp.group)
end

TGetChipInfoRsp.from_obj = TGetChipInfoRsp_from_obj

TGetChipInfoRsp.proto_property = {'CompletionCode', 'EndOfList', 'Data'}

TGetChipInfoRsp.default = {0, 0, ''}

TGetChipInfoRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'EndOfList', is_array = false, struct = nil},
    {name = 'Data', is_array = false, struct = nil}
}

function TGetChipInfoRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'EndOfList', self.EndOfList, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetChipInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetChipInfoRsp.proto_property, errs, need_convert)
    return self
end

function TGetChipInfoRsp:unpack(_)
    return self.CompletionCode, self.EndOfList, self.Data
end

GetChipInfo.GetChipInfoRsp = TGetChipInfoRsp

return GetChipInfo
