--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local ClearCmos = {}

---@class ManufactureIpmiCmds.ClearCmosReq
---@field ManufactureId integer
---@field Action integer
local TClearCmosReq = {}
TClearCmosReq.__index = TClearCmosReq
TClearCmosReq.group = {}

local function TClearCmosReq_from_obj(obj)
    return setmetatable(obj, TClearCmosReq)
end

function TClearCmosReq.new(ManufactureId, Action)
    return TClearCmosReq_from_obj({ManufactureId = ManufactureId, Action = Action})
end
---@param obj ManufactureIpmiCmds.ClearCmosReq
function TClearCmosReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.Action = obj.Action
end

function TClearCmosReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TClearCmosReq.group)
end

TClearCmosReq.from_obj = TClearCmosReq_from_obj

TClearCmosReq.proto_property = {'ManufactureId', 'Action'}

TClearCmosReq.default = {0, 0}

TClearCmosReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'Action', is_array = false, struct = nil}
}

function TClearCmosReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Action', self.Action, 'uint8', false, errs, need_convert)

    TClearCmosReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TClearCmosReq.proto_property, errs, need_convert)
    return self
end

function TClearCmosReq:unpack(_)
    return self.ManufactureId, self.Action
end

ClearCmos.ClearCmosReq = TClearCmosReq

---@class ManufactureIpmiCmds.ClearCmosRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Status integer
local TClearCmosRsp = {}
TClearCmosRsp.__index = TClearCmosRsp
TClearCmosRsp.group = {}

local function TClearCmosRsp_from_obj(obj)
    return setmetatable(obj, TClearCmosRsp)
end

function TClearCmosRsp.new(CompletionCode, ManufactureId, Status)
    return TClearCmosRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId, Status = Status})
end
---@param obj ManufactureIpmiCmds.ClearCmosRsp
function TClearCmosRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Status = obj.Status
end

function TClearCmosRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TClearCmosRsp.group)
end

TClearCmosRsp.from_obj = TClearCmosRsp_from_obj

TClearCmosRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Status'}

TClearCmosRsp.default = {0, 0, 0}

TClearCmosRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Status', is_array = false, struct = nil}
}

function TClearCmosRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Status', self.Status, 'uint8', false, errs, need_convert)

    TClearCmosRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TClearCmosRsp.proto_property, errs, need_convert)
    return self
end

function TClearCmosRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Status
end

ClearCmos.ClearCmosRsp = TClearCmosRsp

return ClearCmos
