-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local Databases = require 'database'
local Col = require 'database.column'

---@class TestTypeTable: Table
---@field Id FieldBase
---@field TestFlag FieldBase
---@field TestType FieldBase

---@class ManufactureDBDatabase
---@field db DataBase
---@field select fun(db:DataBase, table: any, ...): SelectStatement
---@field update fun(db:DataBase, table: any, ...): UpdateStatement
---@field insert fun(db:DataBase, table: any, ...): InsertStatement
---@field TestType TestTypeTable
local ManufactureDBDatabase = {}
ManufactureDBDatabase.__index = ManufactureDBDatabase

function ManufactureDBDatabase.new(path, datas)
    local db = Databases(path)
    local obj = {db = db}

    obj.TestType = db:Table('t_test_type', {
        Id = Col.TextField():cid(1):primary_key(),
        TestFlag = Col.IntegerField():cid(2):null():max_length(8),
        TestType = Col.IntegerField():cid(3):null():max_length(8)
    }, 'protect_reset'):create_if_not_exist(datas and datas['t_test_type'])

    obj.tables = db.tables
    return setmetatable(obj, ManufactureDBDatabase)
end

function ManufactureDBDatabase:select(table, ...)
    return self.db:select(table, ...)
end

function ManufactureDBDatabase:update(table, ...)
    return self.db:update(table, ...)
end

function ManufactureDBDatabase:insert(table, ...)
    return self.db:insert(table, ...)
end

function ManufactureDBDatabase:delete(table, ...)
    return self.db:delete(table, ...)
end

function ManufactureDBDatabase:exec(...)
    return self.db:exec(...)
end

return ManufactureDBDatabase.new
